/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.enums;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public enum RDFNotation {
    RDFXML,
    NTRIPLES,
    TURTLE,
    N3,
    TAR,
    RAR,
    ZIP,
    NQUAD,
    JSONLD,
    LIST,
    DIR,
    HDT;


    public static RDFNotation parse(String str) {
        if (str == null || str.isEmpty()) {
            return NTRIPLES;
        }
        switch (str = str.toLowerCase()) {
            case "ntriples": 
            case "nt": {
                return NTRIPLES;
            }
            case "n3": {
                return N3;
            }
            case "nq": 
            case "nquad": {
                return NQUAD;
            }
            case "rdfxml": 
            case "rdf-xml": 
            case "owl": {
                return RDFXML;
            }
            case "turtle": {
                return TURTLE;
            }
            case "rar": {
                return RAR;
            }
            case "tar": 
            case "tgz": 
            case "tbz": 
            case "tbz2": {
                return TAR;
            }
            case "zip": {
                return ZIP;
            }
            case "list": {
                return LIST;
            }
            case "hdt": {
                return HDT;
            }
        }
        throw new IllegalArgumentException();
    }

    public static RDFNotation guess(String fileName) throws IllegalArgumentException {
        String ext;
        String str = fileName.toLowerCase();
        try {
            if (Files.isDirectory(Path.of(fileName, new String[0]), new LinkOption[0])) {
                return DIR;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        int idx = str.lastIndexOf(46);
        if (idx != -1 && ((ext = str.substring(idx + 1)).equals("gz") || ext.equals("bz") || ext.equals("bz2") || ext.equals("xz"))) {
            str = str.substring(0, idx);
        }
        if (str.endsWith("nt")) {
            return NTRIPLES;
        }
        if (str.endsWith("n3")) {
            return N3;
        }
        if (str.endsWith("nq") || str.endsWith("nquad")) {
            return NQUAD;
        }
        if (str.endsWith("rdf") || str.endsWith("xml") || str.endsWith("owl")) {
            return RDFXML;
        }
        if (str.endsWith("ttl")) {
            return TURTLE;
        }
        if (str.endsWith("tar") || str.endsWith("tgz") || str.endsWith("tbz2")) {
            return TAR;
        }
        if (str.endsWith("rar")) {
            return RAR;
        }
        if (str.endsWith("zip")) {
            return ZIP;
        }
        if (str.endsWith("list")) {
            return LIST;
        }
        if (str.endsWith("hdt")) {
            return HDT;
        }
        throw new IllegalArgumentException("Could not guess the format for " + fileName);
    }

    public static RDFNotation guess(File fileName) throws IllegalArgumentException {
        return RDFNotation.guess(fileName.getAbsolutePath());
    }

    public static RDFNotation guess(Path fileName) throws IllegalArgumentException {
        return RDFNotation.guess(fileName.toAbsolutePath().toString());
    }
}

