/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.enums;

public enum CompressionType {
    GZIP("gz", "tgz"),
    BZIP("bz2", "bz"),
    XZ("xz"),
    NONE(new String[0]);

    private final String[] ext;

    public static CompressionType guess(String fileName) {
        String str = fileName.toLowerCase();
        int idx = str.lastIndexOf(46);
        if (idx != -1) {
            String ext = str.substring(idx + 1);
            for (CompressionType type : CompressionType.values()) {
                for (String typeExt : type.ext) {
                    if (!typeExt.equals(ext)) continue;
                    return type;
                }
            }
        }
        return NONE;
    }

    private CompressionType(String ... ext) {
        this.ext = ext;
    }
}

