/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;

public abstract class BitmapFactory {
    private static BitmapFactory instance;
    public static final byte TYPE_BITMAP_PLAIN = 1;

    private static BitmapFactory getInstance() {
        if (instance == null) {
            try {
                Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.pro.BitmapFactory");
                instance = (BitmapFactory)managerImplClass.newInstance();
            }
            catch (Exception e1) {
                try {
                    Class<?> managerImplClass = Class.forName("org.rdfhdt.hdt.compact.bitmap.BitmapFactoryImpl");
                    instance = (BitmapFactory)managerImplClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Class org.rdfhdt.hdt.compact.bitmap.BitmapFactoryImpl not found. Did you include the HDT implementation jar?");
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Cannot create implementation for BitmapFactory. Does the class org.rdfhdt.hdt.compact.bitmap.BitmapFactoryImpl inherit from BitmapFactory?");
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return instance;
    }

    public static ModifiableBitmap createBitmap(String type) {
        return BitmapFactory.getInstance().doCreateModifiableBitmap(type);
    }

    public static ModifiableBitmap createRWBitmap(long size) {
        return BitmapFactory.getInstance().doCreateRWModifiableBitmap(size);
    }

    public static Bitmap createBitmap(InputStream input) throws IOException {
        return BitmapFactory.getInstance().doCreateBitmap(input);
    }

    public static Bitmap empty() {
        return BitmapFactory.getInstance().doEmpty();
    }

    protected abstract ModifiableBitmap doCreateModifiableBitmap(String var1);

    protected abstract ModifiableBitmap doCreateRWModifiableBitmap(long var1);

    protected abstract Bitmap doCreateBitmap(InputStream var1) throws IOException;

    protected abstract Bitmap doEmpty();
}

