/*
 * Decompiled with CFR 0.152.
 */
package org.rapidpm.vaadin.addons.testbench.junit5.extensions.container;

import java.lang.reflect.Method;
import org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.ContainerInitializer;
import org.rapidpm.vaadin.addons.testbench.junit5.extensions.container.SpringBootConf;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringBootContainerInitializer
implements ContainerInitializer {
    private ApplicationContext applicationContext;

    public void beforeAll(Class<?> testClass) throws Exception {
        SpringBootConf springBootConf = (SpringBootConf)AnnotationUtils.getAnnotation(testClass, SpringBootConf.class);
        if (springBootConf == null) {
            throw new IllegalStateException("No @SpringBootConf annotation found");
        }
        Class<?> appClass = springBootConf.source();
        if (appClass == null) {
            throw new IllegalStateException("No app class defined");
        }
        this.applicationContext = SpringApplication.run(appClass, (String[])springBootConf.args());
    }

    public void beforeEach(Method testMethod) throws Exception {
    }

    public void afterEach(Method testMethod) throws Exception {
    }

    public void afterAll(Class<?> testClass) throws Exception {
        SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
    }
}

