/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.performance;

import java.util.Arrays;
import org.rapidoid.RapidoidThing;
import org.rapidoid.cls.Cls;
import org.rapidoid.config.Conf;
import org.rapidoid.io.IO;
import org.rapidoid.log.Log;
import org.rapidoid.performance.BenchmarkResults;
import org.rapidoid.performance.Perf;
import org.rapidoid.performance.WrkSetup;
import org.rapidoid.setup.App;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class BenchmarkRunner
extends RapidoidThing {
    public static void main(String[] args) {
        Msc.setPlatform((boolean)true);
        App.run((String[])args, (String[])new String[0]);
        String mainClass = (String)Conf.BENCHMARK.entry("main").str().getOrNull();
        String uri = (String)Conf.BENCHMARK.entry("target").str().getOrNull();
        boolean passive = (Boolean)Conf.BENCHMARK.entry("passive").or((Object)false);
        String desc = mainClass + " " + uri + (passive ? " [PASSIVE]" : "");
        Msc.invokeMain((Class)Cls.get((String)mainClass), (String[])args);
        if (!passive) {
            String plan = (String)Conf.BENCHMARK.entry("plan").str().getOrNull();
            String filename = (String)Conf.BENCHMARK.entry("file").str().getOrNull();
            String url = (String)Conf.BENCHMARK.entry("target").str().getOrNull();
            BenchmarkRunner.benchmark(desc, plan, filename, url);
            System.exit(0);
        }
    }

    public static void benchmark(String desc, String plan, String filename, String url) {
        WrkSetup wrk = Perf.wrk().url(url);
        block9: for (String part : plan.split(":")) {
            part = part.toLowerCase();
            char flag = part.charAt(0);
            String val = part.substring(1);
            switch (flag) {
                case 't': {
                    wrk.threads(U.num((String)val));
                    continue block9;
                }
                case 'r': {
                    wrk.rounds(U.num((String)val));
                    continue block9;
                }
                case 'd': {
                    int duration = U.num((String)val);
                    wrk.duration(duration);
                    if (wrk.warmUp() < 0) {
                        wrk.warmUp(duration);
                    }
                    wrk.pause(duration);
                    continue block9;
                }
                case 'c': {
                    wrk.connections(Arrays.stream(val.split(",")).mapToInt(U::num).toArray());
                    continue block9;
                }
                case 'p': {
                    wrk.pipeline(U.num((String)val));
                    continue block9;
                }
                case 's': {
                    wrk.showDetails(false).showWarmUpDetails(false);
                    continue block9;
                }
                case 'w': {
                    wrk.warmUp(U.num((String)val));
                    continue block9;
                }
                default: {
                    throw U.rte((String)("Unknown benchmark option: " + flag));
                }
            }
        }
        Log.info((String)"Running benchmark", (String)"setup", (Object)((Object)wrk));
        BenchmarkResults results = wrk.run();
        String info = U.frmt((String)"%s => %s", (Object[])new Object[]{desc, results.bestThroughput()});
        U.print((Object[])new Object[]{info});
        IO.append((String)filename, (byte[])(info + "\n").getBytes());
    }
}

