/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.performance;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.env.Env;
import org.rapidoid.io.IO;
import org.rapidoid.log.Log;
import org.rapidoid.performance.BenchmarkRunner;
import org.rapidoid.process.Proc;
import org.rapidoid.process.ProcessHandle;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;

public class BenchmarkForker
extends RapidoidThing {
    private final String resultsFile;
    private final String plan;
    private final String target;

    public BenchmarkForker() {
        try {
            this.resultsFile = File.createTempFile("benchmark", ".txt").getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't create temporary file!", e);
        }
        this.plan = (String)Conf.BENCHMARK.entry("plan").str().getOrNull();
        this.target = (String)Conf.BENCHMARK.entry("target").str().getOrNull();
        Log.info((String)"!Starting benchmark", (String)"!configuration", (Object)Conf.BENCHMARK.toMap());
    }

    public void clear() {
        IO.save((String)this.resultsFile, (String)("BENCHMARK plan: " + this.plan + "\n"));
    }

    public ProcessHandle benchmark(Class<?> mainClass, String uri) {
        String classpath = U.join((String)":", (Iterable)ClasspathUtil.getClasspath());
        String runner = BenchmarkRunner.class.getCanonicalName();
        String main = mainClass.getCanonicalName();
        List cmdWithArgs = U.list((Object[])new String[]{"java", "-Xms1g", "-Xmx1g", "-Dfile.encoding=UTF-8", "-classpath", classpath, runner});
        cmdWithArgs.add("benchmark.target=" + uri);
        cmdWithArgs.add("benchmark.main=" + main);
        cmdWithArgs.add("benchmark.file=" + this.resultsFile);
        cmdWithArgs.addAll(Env.args());
        ProcessHandle proc = Proc.printingOutput((boolean)true).linePrefix("[BENCHMARK] ").run((String[])U.arrayOf((Iterable)cmdWithArgs)).waitFor();
        return proc;
    }

    void printResults() {
        U.print((Object[])new Object[]{""});
        U.print((Object[])new Object[]{IO.load((String)this.resultsFile)});
    }

    boolean hasTarget() {
        return this.target != null;
    }

    public void benchmark() {
        BenchmarkRunner.benchmark(this.target, this.plan, this.resultsFile, this.target);
    }
}

