/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.benchmark.lowlevel;

import org.rapidoid.benchmark.common.Message;
import org.rapidoid.buffer.Buf;
import org.rapidoid.http.AbstractHttpServer;
import org.rapidoid.http.HttpStatus;
import org.rapidoid.http.HttpUtils;
import org.rapidoid.http.MediaType;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.RapidoidHelper;

public class PlaintextAndJsonServer
extends AbstractHttpServer {
    private static final byte[] URI_PLAINTEXT = "/plaintext".getBytes();
    private static final byte[] URI_JSON = "/json".getBytes();
    private static final byte[] HELLO_WORLD = "Hello, World!".getBytes();

    public PlaintextAndJsonServer() {
        super("X", "", "", false);
    }

    protected HttpStatus handle(Channel ctx, Buf buf, RapidoidHelper data) {
        if (data.isGet.value) {
            if (this.matches(buf, data.path, URI_PLAINTEXT)) {
                return this.ok(ctx, data.isKeepAlive.value, HELLO_WORLD, MediaType.TEXT_PLAIN);
            }
            if (this.matches(buf, data.path, URI_JSON)) {
                return this.serializeToJson(HttpUtils.noReq(), ctx, data.isKeepAlive.value, new Message("Hello, World!"));
            }
        }
        return HttpStatus.NOT_FOUND;
    }
}

