/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.benchmark.highlevel;

import org.rapidoid.benchmark.common.Message;
import org.rapidoid.benchmark.highlevel.FortunesHandler;
import org.rapidoid.benchmark.highlevel.FortunesMultiHandler;
import org.rapidoid.config.Conf;
import org.rapidoid.env.Env;
import org.rapidoid.http.MediaType;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.jdbc.JDBC;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.log.Log;
import org.rapidoid.setup.App;
import org.rapidoid.setup.On;

public class Main {
    public static void main(String[] args) {
        App.run((String[])args, (String[])new String[0]);
        Conf.HTTP.set("maxPipeline", (Object)128);
        Conf.HTTP.set("timeout", (Object)0);
        Conf.HTTP.sub(new String[]{"mandatoryHeaders"}).set("connection", (Object)false);
        On.port((int)8080);
        Main.setupDbHandlers();
        Main.setupSimpleHandlers();
    }

    private static void setupSimpleHandlers() {
        On.get((String)"/plaintext").managed(false).contentType(MediaType.TEXT_PLAIN).serve("Hello, world!");
        On.get((String)"/json").managed(false).json(() -> new Message("Hello, world!"));
    }

    private static void setupDbHandlers() {
        String dbHost = (String)Conf.ROOT.entry("dbhost").or((Object)"localhost");
        Log.info((String)("Database hostname is: " + dbHost));
        JdbcClient jdbc = JDBC.api();
        if (Env.hasProfile((String)"mysql")) {
            jdbc.url("jdbc:mysql://" + dbHost + ":3306/hello_world?" + "useSSL=false&jdbcCompliantTruncation=false&elideSetAutoCommits=true&useLocalSessionState=true&cachePrepStmts=true&cacheCallableStmts=true&alwaysSendSetIsolation=false&cacheServerConfiguration=true&zeroDateTimeBehavior=convertToNull&traceProtocol=false&enableQueryTimeouts=false&useUnbufferedIO=false&useReadAheadInput=false&maintainTimeStats=false&cacheRSMetadata=true&useServerPrepStmts=true&serverTimezone=UTC");
        } else if (Env.hasProfile((String)"postgres")) {
            jdbc.url("jdbc:postgresql://" + dbHost + ":5432/hello_world?" + "");
        } else {
            jdbc.hsql("public");
            jdbc.execute("create table fortune (id int, message varchar(100))", new Object[0]);
            jdbc.execute("insert into fortune (id, message) values (10, 'Hello')", new Object[0]);
        }
        On.get((String)"/fortunes").managed(false).html((ReqRespHandler)new FortunesHandler(jdbc));
        On.get((String)"/fortunes/multi").html((ReqRespHandler)new FortunesMultiHandler(jdbc));
    }
}

