/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.benchmark.highlevel;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.rapidoid.benchmark.common.Fortune;
import org.rapidoid.http.Req;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.Resp;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.render.Template;
import org.rapidoid.render.Templates;
import org.rapidoid.u.U;
import org.rapidoid.util.Wait;

public class FortunesMultiHandler
implements ReqRespHandler {
    private static final String SQL = "SELECT id, message FROM fortune";
    private static final Mapper<ResultSet, Fortune> resultMapper = rs -> new Fortune(rs.getInt(1), rs.getString(2));
    private final Template template = Templates.load((String)"fortunes.html");
    private final JdbcClient jdbc;

    public FortunesMultiHandler(JdbcClient jdbc) {
        this.jdbc = jdbc;
    }

    public Object execute(Req req, Resp resp) throws Exception {
        int count = U.num((String)req.param("n", "1000"));
        CountDownLatch latch = new CountDownLatch(count);
        for (int i = 0; i < count; ++i) {
            this.jdbc.execute(resultMapper, (fortunes, err) -> {
                if (err == null) {
                    fortunes.add(new Fortune(0, "Additional fortune added at request time."));
                    Collections.sort(fortunes);
                    this.template.renderToBytes(fortunes);
                }
            }, SQL, new Object[0]);
        }
        Wait.on((CountDownLatch)latch);
        return "OK".getBytes();
    }
}

