/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.benchmark.highlevel;

import java.sql.ResultSet;
import java.util.Collections;
import org.rapidoid.benchmark.common.Fortune;
import org.rapidoid.http.Req;
import org.rapidoid.http.ReqRespHandler;
import org.rapidoid.http.Resp;
import org.rapidoid.jdbc.JdbcClient;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.render.Template;
import org.rapidoid.render.Templates;

public class FortunesHandler
implements ReqRespHandler {
    private static final String SQL = "SELECT id, message FROM fortune";
    private static final Mapper<ResultSet, Fortune> resultMapper = rs -> new Fortune(rs.getInt(1), rs.getString(2));
    private static final Template template = Templates.load((String)"fortunes.html");
    private final JdbcClient jdbc;

    public FortunesHandler(JdbcClient jdbc) {
        this.jdbc = jdbc;
    }

    public Object execute(Req req, Resp resp) throws Exception {
        req.async();
        this.jdbc.execute(resultMapper, (fortunes, err) -> {
            if (err == null) {
                fortunes.add(new Fortune(0, "Additional fortune added at request time."));
                Collections.sort(fortunes);
                resp.result((Object)template.renderToBytes(fortunes));
            } else {
                resp.result((Object)err);
            }
            resp.done();
        }, SQL, new Object[0]);
        return req;
    }
}

