/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.performance;

import java.util.Arrays;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.log.Log;
import org.rapidoid.log.LogLevel;
import org.rapidoid.performance.BenchmarkResults;
import org.rapidoid.process.Proc;
import org.rapidoid.process.ProcessHandle;
import org.rapidoid.u.U;

public class WrkSetup
extends RapidoidThing {
    private volatile String url = "/";
    private volatile int[] connections = new int[]{128};
    private volatile int duration = 5;
    private volatile int timeout = 5;
    private volatile int rounds = 1;
    private volatile int warmUp = -1;
    private volatile int pause = 1;
    private volatile int pipeline = 1;
    private volatile int threads;
    private volatile boolean showWarmUpDetails = true;
    private volatile boolean showDetails = true;

    public String url() {
        return this.url;
    }

    public WrkSetup url(String url) {
        this.url = url;
        return this;
    }

    public int[] connections() {
        return this.connections;
    }

    public WrkSetup connections(int[] connections) {
        this.connections = connections;
        return this;
    }

    public int duration() {
        return this.duration;
    }

    public WrkSetup duration(int duration) {
        this.duration = duration;
        return this;
    }

    public int pipeline() {
        return this.pipeline;
    }

    public WrkSetup pipeline(int pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public int timeout() {
        return this.timeout;
    }

    public WrkSetup timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public int rounds() {
        return this.rounds;
    }

    public WrkSetup rounds(int rounds) {
        this.rounds = rounds;
        return this;
    }

    public int threads() {
        return this.threads;
    }

    public WrkSetup threads(int threads) {
        this.threads = threads;
        return this;
    }

    public int warmUp() {
        return this.warmUp;
    }

    public WrkSetup warmUp(int warmUp) {
        this.warmUp = warmUp;
        return this;
    }

    public boolean showWarmUpDetails() {
        return this.showWarmUpDetails;
    }

    public WrkSetup showWarmUpDetails(boolean showWarmUpDetails) {
        this.showWarmUpDetails = showWarmUpDetails;
        return this;
    }

    public boolean showDetails() {
        return this.showDetails;
    }

    public WrkSetup showDetails(boolean showDetails) {
        this.showDetails = showDetails;
        return this;
    }

    public int pause() {
        return this.pause;
    }

    public WrkSetup pause(int pause) {
        this.pause = pause;
        return this;
    }

    public BenchmarkResults run() {
        BenchmarkResults results = new BenchmarkResults();
        if (this.url.startsWith("/")) {
            this.url = "http://localhost:8080" + this.url;
        }
        if (this.warmUp > 0) {
            Log.info((String)"Warming up...", (String)"duration", (Object)this.warmUp);
            ProcessHandle warm = this.runWrk(this.connections[0]);
            if (this.showWarmUpDetails) {
                warm.log(LogLevel.INFO);
            }
        }
        for (int round = 1; round <= this.rounds; ++round) {
            for (int conn : this.connections) {
                U.sleep((long)(this.pause * 1000));
                Log.info((String)"Running benchmark...", (String)"round", (Object)round, (String)"connections", (Object)conn, (String)"duration", (Object)this.duration);
                ProcessHandle proc = this.runWrk(conn);
                if (this.showDetails) {
                    proc.log(LogLevel.INFO);
                }
                this.processResults(results, proc.out(), proc.err());
                Log.info((String)"!Benchmark result", (String)"round", (Object)round, (String)"connections", (Object)conn, (String)"errors", (Object)results.errors, (String)"!throughput", (Object)U.last(results.throughputs));
                Log.info((String)"");
            }
        }
        Log.info((String)"Aggregated benchmark results", (String)"errors", (Object)results.errors, (String)"throughputs", results.throughputs, (String)"best", (Object)results.bestThroughput());
        return results;
    }

    private ProcessHandle runWrk(int conn) {
        List args = U.list((Object[])new String[]{"wrk", "-t", (this.threads > 0 ? this.threads : Runtime.getRuntime().availableProcessors()) + "", "-c", conn + "", "-d", this.duration + "", "--timeout", this.timeout + ""});
        if (this.pipeline > 1) {
            args.add("-s");
            args.add("/opt/pipeline.lua");
        }
        args.add(this.url);
        if (this.pipeline > 1) {
            args.add("--");
            args.add(this.pipeline + "");
        }
        return Proc.run((String[])((String[])U.arrayOf((Iterable)args))).waitFor();
    }

    private void processResults(BenchmarkResults results, List<String> out, List<String> err) {
        ++results.rounds;
        if (!err.isEmpty()) {
            ++results.errors;
            return;
        }
        for (String line : out) {
            if (!line.startsWith("Requests/sec: ")) continue;
            String rps = Str.triml((String)line, (String)"Requests/sec: ");
            double throughput = Double.parseDouble(rps);
            results.throughputs.add(throughput);
            return;
        }
        Log.error((String)"Couldn't parse the benchmark output!");
        ++results.errors;
    }

    public String toString() {
        return "WrkSetup{url='" + this.url + '\'' + ", connections=" + Arrays.toString(this.connections) + ", duration=" + this.duration + ", timeout=" + this.timeout + ", rounds=" + this.rounds + ", warmUp=" + this.warmUp + ", pause=" + this.pause + ", pipeline=" + this.pipeline + ", threads=" + this.threads + ", showWarmUpDetails=" + this.showWarmUpDetails + ", showDetails=" + this.showDetails + '}';
    }
}

