/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.GrammarContext;
import org.raml.yagi.framework.grammar.RuleFactory;
import org.raml.yagi.framework.grammar.rule.AllOfRule;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.AnyValueRule;
import org.raml.yagi.framework.grammar.rule.ArrayRule;
import org.raml.yagi.framework.grammar.rule.BooleanTypeRule;
import org.raml.yagi.framework.grammar.rule.ChildBasedConditionalRule;
import org.raml.yagi.framework.grammar.rule.ConditionalRule;
import org.raml.yagi.framework.grammar.rule.ConditionalRules;
import org.raml.yagi.framework.grammar.rule.DefaultValue;
import org.raml.yagi.framework.grammar.rule.ExclusiveKeys;
import org.raml.yagi.framework.grammar.rule.FieldPresentRule;
import org.raml.yagi.framework.grammar.rule.FirstOfRule;
import org.raml.yagi.framework.grammar.rule.IntegerTypeRule;
import org.raml.yagi.framework.grammar.rule.IntegerValueRule;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.MinLengthRule;
import org.raml.yagi.framework.grammar.rule.NegativeRule;
import org.raml.yagi.framework.grammar.rule.NullValueRule;
import org.raml.yagi.framework.grammar.rule.NumberTypeRule;
import org.raml.yagi.framework.grammar.rule.ObjectRule;
import org.raml.yagi.framework.grammar.rule.ParentKeyDefaultValue;
import org.raml.yagi.framework.grammar.rule.RangeValueRule;
import org.raml.yagi.framework.grammar.rule.RegexValueRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.ScalarTypeRule;
import org.raml.yagi.framework.grammar.rule.StringTypeRule;
import org.raml.yagi.framework.grammar.rule.StringValueRule;

public class BaseGrammar {
    private GrammarContext context = new GrammarContext();
    @Nullable
    private String nextRuleName;

    public ObjectRule objectType() {
        return this.register(new ObjectRule());
    }

    private <T extends Rule> T register(T rule) {
        if (this.nextRuleName != null) {
            this.context.registerRule(this.nextRuleName, rule);
            this.nextRuleName = null;
        }
        return rule;
    }

    public <T extends Rule> T named(String name, RuleFactory<T> ruleFactory) {
        if (this.context.hasRule(name)) {
            return (T)this.context.getRuleByName(name);
        }
        this.nextRuleName = name;
        return ruleFactory.create();
    }

    public <T extends Rule> T inNewContext(Callable<T> callable) {
        Rule result;
        GrammarContext oldContext = this.context;
        this.context = new GrammarContext();
        try {
            result = (Rule)callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.context = oldContext;
        return (T)result;
    }

    public ChildBasedConditionalRule whenChildIs(Rule condition, Rule then) {
        return new ChildBasedConditionalRule(condition, then);
    }

    public FieldPresentRule whenPresent(String selector, Rule then) {
        return new FieldPresentRule(selector, then);
    }

    public AnyValueRule any() {
        return new AnyValueRule();
    }

    public ArrayRule array(Rule of) {
        return new ArrayRule(of);
    }

    public IntegerTypeRule integerType() {
        return new IntegerTypeRule();
    }

    public IntegerTypeRule positiveIntegerType(boolean includesZero, Long maxValue) {
        return new IntegerTypeRule((Range<Long>)Range.closed((Comparable)Long.valueOf(includesZero ? 0L : 1L), (Comparable)maxValue));
    }

    public Rule numberType() {
        return new NumberTypeRule();
    }

    public Rule positiveNumberType() {
        return new NumberTypeRule((Range<Double>)Range.greaterThan((Comparable)Double.valueOf(0.0)));
    }

    public RangeValueRule range(Integer min, Integer max) {
        return new RangeValueRule(min, max);
    }

    public IntegerValueRule integer(Integer value) {
        return new IntegerValueRule(new BigInteger(value.toString()));
    }

    public KeyValueRule field(Rule keyRule, Rule valueRule) {
        return new KeyValueRule(keyRule, this.optional(valueRule));
    }

    public KeyValueRule field(String keyName, Rule valueRule) {
        return new KeyValueRule(this.string(keyName), this.optional(valueRule));
    }

    public KeyValueRule fieldWithRequiredValue(Rule keyRule, Rule valueRule) {
        return new KeyValueRule(keyRule, valueRule);
    }

    public KeyValueRule requiredField(Rule keyRule, Rule valueRule) {
        return new KeyValueRule(keyRule, valueRule).required();
    }

    public Rule scalarType() {
        return new ScalarTypeRule();
    }

    public StringTypeRule stringType() {
        return new StringTypeRule();
    }

    public BooleanTypeRule booleanType() {
        return new BooleanTypeRule();
    }

    public StringValueRule string(String value) {
        return new StringValueRule(value);
    }

    public RegexValueRule regex(String pattern) {
        return new RegexValueRule(Pattern.compile(pattern));
    }

    public RegexValueRule regex(Pattern pattern) {
        return new RegexValueRule(pattern);
    }

    public AnyOfRule anyOf(Rule ... rules) {
        return new AnyOfRule(Arrays.asList(rules));
    }

    public AnyOfRule anyOf(List<Rule> rules) {
        return new AnyOfRule(rules);
    }

    public AnyOfRule firstOf(Rule ... rules) {
        return new FirstOfRule(Arrays.asList(rules));
    }

    public NegativeRule not(Rule rule) {
        return new NegativeRule(rule);
    }

    public AllOfRule allOf(Rule ... rules) {
        return new AllOfRule(Arrays.asList(rules));
    }

    public AnyOfRule optional(Rule rule) {
        return this.anyOf(rule, this.nullValue());
    }

    public MinLengthRule minLength(int length) {
        return new MinLengthRule(length);
    }

    protected NullValueRule nullValue() {
        return new NullValueRule();
    }

    public ConditionalRules when(String expr, ConditionalRule ... cases) {
        return new ConditionalRules(Collections.singletonList(expr), cases);
    }

    public ConditionalRules when(List<String> expr, ConditionalRule ... cases) {
        return new ConditionalRules(expr, cases);
    }

    public ConditionalRule is(Rule rule) {
        return new ConditionalRule(rule);
    }

    public DefaultValue parentKey() {
        return new ParentKeyDefaultValue();
    }

    public ExclusiveKeys exclusiveKeys(String ... keys) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (String key : keys) {
            rules.add(this.string(key));
        }
        return new ExclusiveKeys(rules);
    }
}

