/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.resolver.Resolver;
import sun.misc.Unsafe;

public class ReflectionFieldsOverride {
    private final Pattern originalFloatPattern = Pattern.compile("^([-+]?(\\.[0-9]+|[0-9_]+(\\.[0-9_]*)?)([eE][-+]?[0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
    private final Pattern originalIntPattern = Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?[0-9])+)$");

    public void setFinalStatic(Field field, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        Object fieldBase = unsafe.staticFieldBase(field);
        long fieldOffset = unsafe.staticFieldOffset(field);
        unsafe.putObject(fieldBase, fieldOffset, value);
    }

    public void overrideSnakeYAMLPatterns() {
        try {
            Class<Resolver> resolverClass = Resolver.class;
            this.setFinalStatic(resolverClass.getDeclaredField("FLOAT"), this.originalFloatPattern);
            this.setFinalStatic(resolverClass.getDeclaredField("INT"), this.originalIntPattern);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

