/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import java.io.Writer;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ReferenceNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.util.NodeAppender;
import org.raml.yagi.framework.util.NodeAppenderFactory;

public class TreeNodeDumper {
    private static final int TAB_SPACES = 4;
    protected NodeAppender dump;
    private int indent = 0;
    private boolean dumpOn = true;

    public TreeNodeDumper(NodeAppender dump) {
        this.dump = dump;
    }

    public TreeNodeDumper(Writer writer) {
        this(NodeAppenderFactory.stringBuilder(writer));
    }

    public String dump(Node node) {
        this.printIndent();
        this.dumpNode(node);
        this.dump.append(" (");
        this.dump.append("Start: ").append(node.getStartPosition().getIndex());
        this.dump.append(" , End: ").append(node.getEndPosition().getIndex());
        if (node.getStartPosition().getIndex() != -1 && node.getEndPosition().getIndex() != -1 && this.dumpOn) {
            this.dump.append(", On: ").append(node.getStartPosition().getPath());
        }
        if (node.getSource() != null) {
            this.dump.append(", Source: ");
            this.dump.append(node.getSource().getClass().getSimpleName());
        }
        this.dump.append(")");
        this.dump.append("\n");
        this.indent();
        this.dumpChildren(node);
        this.dedent();
        this.dump.dump();
        return "";
    }

    protected void dumpChildren(Node node) {
        for (Node child : this.getChildren(node)) {
            this.dump(child);
        }
    }

    public TreeNodeDumper dumpOn(boolean dumpOn) {
        this.dumpOn = dumpOn;
        return this;
    }

    protected Collection<Node> getChildren(Node node) {
        return node.getChildren();
    }

    protected void dumpNode(Node node) {
        this.dump.append(node.getClass().getSimpleName());
        if (node instanceof ReferenceNode) {
            this.dumpReference((ReferenceNode)node);
        } else if (node instanceof StringNode) {
            this.dump.append(": \"").append(((StringNode)node).getValue()).append("\"");
        } else if (node instanceof SimpleTypeNode) {
            this.dump.append(": ").append(((SimpleTypeNode)node).getValue());
        } else if (node instanceof ErrorNode) {
            this.dump.append(": \"").append(((ErrorNode)node).getErrorMessage()).append("\"");
        }
    }

    private void dumpReference(ReferenceNode node) {
        ReferenceNode referenceNode = node;
        Node refNode = referenceNode.getRefNode();
        this.dump.append(" ").append(referenceNode.getRefName()).append(" -> {").append(refNode == null ? "null" : refNode.getClass().getSimpleName());
        if (refNode != null) {
            this.dump.append(" RefStart: ").append(refNode.getStartPosition().getIndex());
            this.dump.append(" , RefEnd: ").append(refNode.getEndPosition().getIndex());
        }
        this.dump.append("}");
    }

    protected void dedent() {
        --this.indent;
    }

    protected void indent() {
        ++this.indent;
    }

    protected void printIndent() {
        this.dump.append(StringUtils.repeat((String)" ", (int)(this.indent * 4)));
    }
}

