/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.util;

import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.raml.yagi.framework.util.DateType;

public class DateUtils {
    private static DateTimeFormatter hourFormatter = DateTimeFormat.forPattern((String)"HH:mm:ss");
    private static DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"YYYY-MM-DD");
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"YYYY-MM-DD'T'HH:mm:ss");
    private static DateTimeFormatter dateTimeSecondFormatter = DateTimeFormat.forPattern((String)"YYYY-MM-DD'T'HH:mm:ss.SSS'Z'");
    private static DateTimeFormatter rfc2616Formatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss zzz");

    public static boolean isValidDate(String date, DateType format, String rfc) {
        try {
            switch (format) {
                case date_only: {
                    dateFormatter.parseLocalDate(date);
                    break;
                }
                case time_only: {
                    hourFormatter.parseLocalTime(date);
                    break;
                }
                case datetime_only: {
                    dateTimeFormatter.parseLocalDateTime(date);
                    break;
                }
                case datetime: {
                    if (rfc != null && "rfc2616".equals(rfc)) {
                        rfc2616Formatter.parseLocalDateTime(date);
                        break;
                    }
                    dateTimeSecondFormatter.parseLocalDateTime(date);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

