/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.jackson.JModelWrapper;

public class JNodeParser {
    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, Reader reader) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode rootNode = (JsonNode)mapper.readValue(reader, JsonNode.class);
            return new JModelWrapper(resourceLoader, resourcePath).wrap(rootNode);
        }
        catch (JsonParseException | JsonMappingException e) {
            return ErrorNodeFactory.createInvalidJsonExampleNode(e.getOriginalMessage());
        }
        catch (IOException e) {
            return new ErrorNode(e.getMessage());
        }
    }

    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, String content) {
        return JNodeParser.parse(resourceLoader, resourcePath, new StringReader(content));
    }
}

