/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.CompoundIncludeResolver;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.PojoValidatorTagResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.RamlDocumentValidator;
import org.raml.parser.visitor.YamlValidationService;
import org.yaml.snakeyaml.nodes.MappingNode;

public class RamlValidationService
extends YamlValidationService {
    public RamlValidationService(ResourceLoader resourceLoader, RamlDocumentValidator ramlDocumentValidator, TagResolver ... tagResolvers) {
        super(resourceLoader, ramlDocumentValidator, RamlValidationService.defaultResolver(tagResolvers));
    }

    private static TagResolver[] defaultResolver(TagResolver[] tagResolvers) {
        Object[] defaultResolvers = new TagResolver[]{new IncludeResolver(), new CompoundIncludeResolver(), new PojoValidatorTagResolver()};
        return (TagResolver[])ArrayUtils.addAll((Object[])defaultResolvers, (Object[])tagResolvers);
    }

    @Override
    protected List<ValidationResult> preValidation(MappingNode root) {
        List<ValidationResult> validationResults = this.getValidator().getTemplateResolver().init(root);
        validationResults.addAll(this.getValidator().getMediaTypeResolver().beforeDocumentStart(root));
        return validationResults;
    }

    public static RamlValidationService createDefault() {
        return RamlValidationService.createDefault((ResourceLoader)new DefaultResourceLoader(), new TagResolver[0]);
    }

    public static RamlValidationService createDefault(ResourceLoader loader, TagResolver ... tagResolvers) {
        return RamlValidationService.createDefault(loader, new NodeRuleFactory(new NodeRuleFactoryExtension[0]), tagResolvers);
    }

    public static RamlValidationService createDefault(ResourceLoader loader, NodeRuleFactory nodeRuleFactory, TagResolver ... tagResolvers) {
        return new RamlValidationService(loader, new RamlDocumentValidator(nodeRuleFactory), tagResolvers);
    }

    @Override
    protected RamlDocumentValidator getValidator() {
        return (RamlDocumentValidator)super.getValidator();
    }
}

