/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.NodeRuleFactory;
import org.raml.parser.rule.NodeRuleFactoryExtension;
import org.raml.parser.rule.SequenceRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlValidator;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDocumentValidator
implements YamlValidator {
    private Class<?> documentClass;
    private Stack<NodeRule<?>> ruleContext = new Stack();
    private Stack<String> includeContext = new Stack();
    private List<ValidationResult> messages = new ArrayList<ValidationResult>();
    private NodeRuleFactory nodeRuleFactory;

    protected YamlDocumentValidator(Class<?> documentClass) {
        this(documentClass, new NodeRuleFactory(new NodeRuleFactoryExtension[0]));
    }

    protected YamlDocumentValidator(Class<?> documentClass, NodeRuleFactory nodeRuleFactory) {
        this.documentClass = documentClass;
        this.nodeRuleFactory = nodeRuleFactory;
    }

    protected Stack<NodeRule<?>> getRuleContext() {
        return this.ruleContext;
    }

    @Override
    public void onMappingNodeStart(MappingNode mappingNode) {
    }

    @Override
    public void onMappingNodeEnd(MappingNode mappingNode) {
    }

    @Override
    public void onSequenceStart(SequenceNode node, TupleType tupleType) {
        List<ValidationResult> result = new ArrayList<ValidationResult>();
        NodeRule<?> peek = this.ruleContext.peek();
        switch (tupleType) {
            case VALUE: {
                result = peek.validateValue(node);
            }
        }
        this.addMessagesIfRequired((Node)node, result);
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        List<ValidationResult> result;
        NodeRule<?> peek = this.ruleContext.peek();
        switch (tupleType) {
            case VALUE: {
                result = peek.validateValue(node);
                break;
            }
            default: {
                result = ((TupleRule)peek).validateKey(node);
            }
        }
        this.addMessagesIfRequired((Node)node, result);
    }

    private void addMessagesIfRequired(Node node, List<ValidationResult> result) {
        for (ValidationResult validationResult : result) {
            validationResult.setIncludeName(this.includeContext.empty() ? null : this.includeContext.peek());
            this.messages.add(validationResult);
        }
    }

    @Override
    public void onDocumentStart(MappingNode node) {
        this.ruleContext.push(this.buildDocumentRule());
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        NodeRule<?> pop = this.ruleContext.pop();
        List<ValidationResult> onRuleEnd = pop.onRuleEnd();
        this.addMessagesIfRequired((Node)node, onRuleEnd);
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        NodeRule<?> rule = this.ruleContext.pop();
        if (rule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        List<ValidationResult> onRuleEnd = rule.onRuleEnd();
        this.addMessagesIfRequired(nodeTuple.getKeyNode(), onRuleEnd);
    }

    @Override
    public void onTupleStart(NodeTuple nodeTuple) {
        TupleRule tupleRule = (TupleRule)this.ruleContext.peek();
        if (tupleRule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        TupleRule<?, ?> rule = tupleRule.getRuleForTuple(nodeTuple);
        this.ruleContext.push(rule);
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
        NodeRule<?> peek = this.ruleContext.peek();
        if (!(peek instanceof SequenceRule)) {
            this.ruleContext.push(peek);
        } else {
            this.ruleContext.push(((SequenceRule)((Object)peek)).getItemRule());
        }
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
        NodeRule<?> rule = this.ruleContext.pop();
        List<ValidationResult> validationResults = rule.onRuleEnd();
        this.addMessagesIfRequired(sequenceNode, validationResults);
    }

    @Override
    public void onCustomTagStart(Tag tag, Node originalValueNode, NodeTuple nodeTuple) {
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag)) {
            this.includeContext.push(((ScalarNode)originalValueNode).getValue());
        }
    }

    @Override
    public void onCustomTagEnd(Tag tag, Node originalValueNode, NodeTuple nodeTuple) {
        String expectedInclude;
        String actualInclude;
        if (IncludeResolver.INCLUDE_TAG.equals((Object)tag) && !(actualInclude = this.includeContext.pop()).equals(expectedInclude = ((ScalarNode)originalValueNode).getValue())) {
            throw new IllegalStateException(String.format("actualInclude zombie! (actual: %s, expected: %s)", actualInclude, expectedInclude));
        }
    }

    @Override
    public void onCustomTagError(Tag tag, Node node, String message) {
        this.addMessagesIfRequired(node, Arrays.asList(ValidationResult.createErrorResult(message, node.getStartMark(), node.getEndMark())));
    }

    private DefaultTupleRule<Node, MappingNode> buildDocumentRule() {
        return this.nodeRuleFactory.createDocumentRule(this.documentClass);
    }

    @Override
    public List<ValidationResult> getMessages() {
        return this.messages;
    }
}

