/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.loader.ResourceLoaderAware;
import org.raml.parser.tagresolver.ContextPath;
import org.raml.parser.tagresolver.ContextPathAware;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.RamlParsingLimitsController;
import org.raml.parser.visitor.ReflectionFieldsOverride;
import org.raml.parser.visitor.SchemaCompiler;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class NodeVisitor {
    public static final Tag LOOP_TAG = new Tag("!loop");
    private NodeHandler nodeHandler;
    private ResourceLoader resourceLoader;
    private TagResolver[] tagResolvers;
    private Deque<String> loopDetector = new ArrayDeque<String>();
    private ContextPath contextPath = new ContextPath();
    private final RamlParsingLimitsController controller = new RamlParsingLimitsController();
    private final ReflectionFieldsOverride fieldsOverride = new ReflectionFieldsOverride();

    public NodeVisitor(NodeHandler nodeHandler, ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        this.fieldsOverride.overrideSnakeYAMLPatterns();
        this.nodeHandler = nodeHandler;
        this.resourceLoader = resourceLoader;
        this.tagResolvers = tagResolvers;
        this.initializeContextPathAware(tagResolvers);
        this.initializeResourceLoaderAware();
        SchemaCompiler.getInstance().init(this.contextPath, resourceLoader);
    }

    private void initializeResourceLoaderAware() {
        if (this.nodeHandler instanceof ResourceLoaderAware) {
            ((ResourceLoaderAware)((Object)this.nodeHandler)).setResourceLoader(this.resourceLoader);
        }
    }

    private void initializeContextPathAware(TagResolver[] tagResolvers) {
        for (TagResolver tagResolver : tagResolvers) {
            if (!(tagResolver instanceof ContextPathAware)) continue;
            ((ContextPathAware)((Object)tagResolver)).setContextPath(this.contextPath);
        }
        if (this.nodeHandler instanceof ContextPathAware) {
            ((ContextPathAware)((Object)this.nodeHandler)).setContextPath(this.contextPath);
        }
    }

    private void visitMappingNode(MappingNode mappingNode, TupleType tupleType, int depth) {
        if (this.checkLoop((Node)mappingNode)) {
            this.nodeHandler.onCustomTagError(LOOP_TAG, (Node)mappingNode, "Circular reference detected");
            return;
        }
        boolean keepOnVisiting = this.nodeHandler.onMappingNodeStart(mappingNode, tupleType);
        if (tupleType == TupleType.VALUE && keepOnVisiting) {
            this.doVisitMappingNode(mappingNode, depth);
        }
        this.nodeHandler.onMappingNodeEnd(mappingNode, tupleType);
        if (mappingNode.getStartMark() != null) {
            this.loopDetector.pop();
        }
    }

    private boolean checkLoop(Node node) {
        if (node.getStartMark() == null) {
            return false;
        }
        String index = this.contextPath.peek().getIncludeName() + node.getStartMark().getIndex();
        if (this.loopDetector.contains(index)) {
            return true;
        }
        this.loopDetector.push(index);
        return false;
    }

    private void doVisitMappingNode(MappingNode mappingNode, int depth) {
        if (mappingNode.isMerged()) {
            new MappingNodeMerger().merge(mappingNode);
        }
        List tuples = mappingNode.getValue();
        ArrayList<NodeTuple> updatedTuples = new ArrayList<NodeTuple>();
        for (NodeTuple nodeTuple : tuples) {
            TagResolver currentTagResolver;
            Tag tag;
            Node resolvedNode;
            Node keyNode = nodeTuple.getKeyNode();
            Node originalValueNode = nodeTuple.getValueNode();
            if (originalValueNode != (resolvedNode = this.resolveTag(tag = originalValueNode.getTag(), currentTagResolver = this.getTagResolver(tag), originalValueNode))) {
                nodeTuple = new NodeTuple(keyNode, resolvedNode);
            }
            updatedTuples.add(nodeTuple);
            boolean processTuple = this.nodeHandler.onTupleStart(nodeTuple);
            if (!processTuple) continue;
            this.visit(keyNode, TupleType.KEY, depth);
            this.visitResolvedNode(originalValueNode, resolvedNode, currentTagResolver, depth);
            this.nodeHandler.onTupleEnd(nodeTuple);
        }
        mappingNode.setValue(updatedTuples);
    }

    private Node resolveTag(Tag tag, TagResolver tagResolver, Node valueNode) {
        if (tagResolver != null) {
            valueNode = tagResolver.resolve(valueNode, this.resourceLoader, this.nodeHandler);
        } else if (!NodeUtils.isStandardTag(tag)) {
            this.nodeHandler.onCustomTagError(tag, valueNode, "Unknown tag " + tag);
        }
        return valueNode;
    }

    private void visitResolvedNode(Node originalValueNode, Node resolvedNode, TagResolver tagResolver, int depth) {
        boolean tagResolved;
        Tag tag = originalValueNode.getTag();
        boolean bl = tagResolved = tagResolver != null;
        if (tagResolved) {
            tagResolver.beforeProcessingResolvedNode(tag, originalValueNode, resolvedNode);
            this.nodeHandler.onCustomTagStart(tag, originalValueNode, resolvedNode);
        }
        this.visit(resolvedNode, TupleType.VALUE, depth);
        if (tagResolved) {
            this.nodeHandler.onCustomTagEnd(tag, originalValueNode, resolvedNode);
            tagResolver.afterProcessingResolvedNode(tag, originalValueNode, resolvedNode);
        }
    }

    private TagResolver getTagResolver(Tag tag) {
        for (TagResolver resolver : this.tagResolvers) {
            if (!resolver.handles(tag)) continue;
            return resolver;
        }
        return null;
    }

    public void visitDocument(MappingNode node) {
        boolean keepOnVisitingDocument = this.nodeHandler.onDocumentStart(node);
        if (node != null && keepOnVisitingDocument) {
            if (this.contextPath.size() == 0) {
                this.contextPath.pushRoot("");
            }
            this.doVisitMappingNode(node, 0);
        }
        this.nodeHandler.onDocumentEnd(node);
    }

    private void visit(Node node, TupleType tupleType, int depth) {
        this.controller.verifyNode(node, 0);
        if (node.getNodeId() == NodeId.mapping) {
            this.visitMappingNode((MappingNode)node, tupleType, depth + 1);
        } else if (node.getNodeId() == NodeId.scalar) {
            this.visitScalar((ScalarNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.sequence) {
            this.visitSequence((SequenceNode)node, tupleType, depth + 1);
        }
    }

    private void visitSequence(SequenceNode node, TupleType tupleType, int depth) {
        boolean keepVisitingElements = this.nodeHandler.onSequenceStart(node, tupleType);
        if (tupleType == TupleType.VALUE && keepVisitingElements) {
            List value = node.getValue();
            for (int i = 0; i < value.size(); ++i) {
                Node originalNode = (Node)value.get(i);
                TagResolver currentTagResolver = this.getTagResolver(originalNode.getTag());
                Node resolvedNode = this.resolveTag(originalNode.getTag(), currentTagResolver, originalNode);
                if (originalNode != resolvedNode) {
                    node.getValue().remove(i);
                    node.getValue().add(i, resolvedNode);
                }
                this.nodeHandler.onSequenceElementStart(resolvedNode);
                this.visitResolvedNode(originalNode, resolvedNode, currentTagResolver, depth);
                this.nodeHandler.onSequenceElementEnd(resolvedNode);
            }
        }
        this.nodeHandler.onSequenceEnd(node, tupleType);
    }

    private void visitScalar(ScalarNode node, TupleType tupleType) {
        this.nodeHandler.onScalar(node, tupleType);
    }

    private static class MappingNodeMerger
    extends SafeConstructor {
        private MappingNodeMerger() {
        }

        void merge(MappingNode mappingNode) {
            this.flattenMapping(mappingNode);
        }
    }
}

