/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.utils.Inflector;
import org.raml.parser.visitor.NodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver {
    public static final String OPTIONAL_MODIFIER = "?";
    public static final String ALL_ACTIONS = "*";
    public static final String TRAIT_USE_KEY = "is";
    public static final String RESOURCE_TYPE_USE_KEY = "type";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IncludeResolver includeResolver = new IncludeResolver();
    private Map<String, MappingNode> resourceTypesMap = new HashMap<String, MappingNode>();
    private Map<String, MappingNode> traitsMap = new HashMap<String, MappingNode>();
    private ResourceLoader resourceLoader;
    private NodeHandler nodeNandler;
    private Set<MappingNode> resolvedNodes = new HashSet<MappingNode>();

    public TemplateResolver(ResourceLoader resourceLoader, NodeHandler nodeNandler) {
        this.resourceLoader = resourceLoader;
        this.nodeNandler = nodeNandler;
    }

    public Map<String, MappingNode> getResourceTypesMap() {
        return this.resourceTypesMap;
    }

    public Map<String, MappingNode> getTraitsMap() {
        return this.traitsMap;
    }

    public List<ValidationResult> init(MappingNode rootNode) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (rootNode == null) {
            validationResults.add(ValidationResult.createErrorResult("Invalid Root Node"));
            return validationResults;
        }
        for (int i = 0; i < rootNode.getValue().size(); ++i) {
            String key;
            NodeTuple rootTuple = (NodeTuple)rootNode.getValue().get(i);
            Node keyNode = rootTuple.getKeyNode();
            if (keyNode.getNodeId() != NodeId.scalar || !(key = ((ScalarNode)keyNode).getValue()).equals("resourceTypes") && !key.equals("traits")) continue;
            Node templateSequence = rootTuple.getValueNode();
            if (templateSequence.getNodeId() == NodeId.scalar) {
                if (!templateSequence.getTag().equals((Object)IncludeResolver.INCLUDE_TAG)) {
                    validationResults.add(ValidationResult.createErrorResult("Sequence or !include expected", templateSequence));
                    break;
                }
                templateSequence = this.includeResolver.resolve(templateSequence, this.resourceLoader, this.nodeNandler);
                rootNode.getValue().remove(i);
                rootNode.getValue().add(i, new NodeTuple(keyNode, templateSequence));
            }
            if (templateSequence.getNodeId() != NodeId.sequence) {
                validationResults.add(ValidationResult.createErrorResult("Sequence expected", templateSequence));
                rootNode.getValue().remove(i);
                rootNode.getValue().add(i, new NodeTuple(keyNode, (Node)new SequenceNode(Tag.SEQ, new ArrayList(), Boolean.valueOf(false))));
                break;
            }
            this.loopTemplateSequence((SequenceNode)templateSequence, key, validationResults);
        }
        return validationResults;
    }

    private void loopTemplateSequence(SequenceNode templateSequence, String templateType, List<ValidationResult> validationResults) {
        ArrayList<Node> prunedTemplates = new ArrayList<Node>();
        for (int j = 0; j < templateSequence.getValue().size(); ++j) {
            Node template = (Node)templateSequence.getValue().get(j);
            if (template.getNodeId() == NodeId.scalar) {
                if (!template.getTag().equals((Object)IncludeResolver.INCLUDE_TAG)) {
                    validationResults.add(ValidationResult.createErrorResult("Mapping or !include expected", templateSequence.getStartMark(), templateSequence.getEndMark()));
                }
                template = this.includeResolver.resolve(template, this.resourceLoader, this.nodeNandler);
            }
            for (NodeTuple tuple : ((MappingNode)template).getValue()) {
                if (tuple.getKeyNode().getNodeId() != NodeId.scalar) {
                    validationResults.add(ValidationResult.createErrorResult("Only scalar keys are allowed", tuple.getKeyNode()));
                    continue;
                }
                String templateKey = ((ScalarNode)tuple.getKeyNode()).getValue();
                Node templateValue = tuple.getValueNode();
                if (templateValue.getNodeId() != NodeId.mapping) {
                    validationResults.add(ValidationResult.createErrorResult("Mapping expected", templateValue.getStartMark(), templateValue.getEndMark()));
                    continue;
                }
                if (templateType.equals("resourceTypes")) {
                    this.resourceTypesMap.put(templateKey, (MappingNode)templateValue);
                }
                if (templateType.equals("traits")) {
                    this.traitsMap.put(templateKey, (MappingNode)templateValue);
                }
                prunedTemplates.add(this.getFakeTemplateNode(tuple.getKeyNode()));
            }
        }
        templateSequence.getValue().clear();
        templateSequence.getValue().addAll(prunedTemplates);
    }

    private Node getFakeTemplateNode(Node keyNode) {
        ArrayList<NodeTuple> innerTuples = new ArrayList<NodeTuple>();
        innerTuples.add(new NodeTuple((Node)new ScalarNode(Tag.STR, "displayName", null, null, null), keyNode));
        MappingNode innerNode = new MappingNode(Tag.MAP, innerTuples, Boolean.valueOf(false));
        ArrayList<NodeTuple> outerTuples = new ArrayList<NodeTuple>();
        outerTuples.add(new NodeTuple(keyNode, (Node)innerNode));
        return new MappingNode(Tag.MAP, outerTuples, Boolean.valueOf(false));
    }

    public List<ValidationResult> resolve(MappingNode resourceNode, String relativeUri, String fullUri) {
        ArrayList<ValidationResult> templateValidations = new ArrayList<ValidationResult>();
        if (this.resolvedNodes.contains(resourceNode)) {
            return templateValidations;
        }
        this.resolvedNodes.add(resourceNode);
        return new ResourceTemplateMerger(templateValidations, resourceNode, relativeUri, fullUri).merge();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceTemplateMerger {
        private List<ValidationResult> templateValidations;
        private MappingNode resourceNode;
        private String relativeUri;
        private String fullUri;
        private String currentAction;

        public ResourceTemplateMerger(List<ValidationResult> templateValidations, MappingNode resourceNode, String relativeUri, String fullUri) {
            this.templateValidations = templateValidations;
            this.resourceNode = resourceNode;
            this.relativeUri = relativeUri;
            this.fullUri = fullUri;
        }

        public List<ValidationResult> merge() {
            if (this.mergeTemplatesIfNeeded(this.resourceNode, new HashMap<String, Node>())) {
                this.removeOptionalNodes(this.resourceNode, true);
            }
            return this.templateValidations;
        }

        private boolean mergeTemplatesIfNeeded(MappingNode resourceNode, Map<String, Node> globalActionNodes) {
            NodeTuple resourceTuple;
            Node typeReference = null;
            HashMap<String, SequenceNode> traitsReference = new HashMap<String, SequenceNode>();
            HashMap<String, Node> actionNodes = new HashMap<String, Node>(globalActionNodes);
            for (int i = 0; i < resourceNode.getValue().size() && (resourceTuple = (NodeTuple)resourceNode.getValue().get(i)).getKeyNode().getNodeId() == NodeId.scalar; ++i) {
                String key = ((ScalarNode)resourceTuple.getKeyNode()).getValue();
                if (key.equals(TemplateResolver.RESOURCE_TYPE_USE_KEY)) {
                    typeReference = this.cloneNode(resourceTuple.getValueNode(), new HashMap<String, String>());
                    this.removeParametersFromTemplateCall(resourceTuple);
                    continue;
                }
                if (key.equals(TemplateResolver.TRAIT_USE_KEY)) {
                    SequenceNode sequence = this.cloneSequenceNode((SequenceNode)resourceTuple.getValueNode(), new HashMap<String, String>());
                    traitsReference.put(TemplateResolver.ALL_ACTIONS, sequence);
                    this.removeParametersFromTraitsCall(resourceTuple);
                    continue;
                }
                if (!this.isAction(key)) continue;
                Node actionNode = resourceTuple.getValueNode();
                if (actionNode.getTag().equals((Object)Tag.NULL)) {
                    actionNode = this.setTupleValueToEmptyMappingNode(resourceTuple);
                } else if (actionNode.getTag().equals((Object)IncludeResolver.INCLUDE_TAG)) {
                    actionNode = TemplateResolver.this.includeResolver.resolve(actionNode, TemplateResolver.this.resourceLoader, TemplateResolver.this.nodeNandler);
                    resourceNode.getValue().remove(i);
                    resourceNode.getValue().add(i, new NodeTuple(resourceTuple.getKeyNode(), actionNode));
                }
                if (actionNode.getNodeId() != NodeId.mapping) break;
                actionNodes.put(this.normalizeKey(key), actionNode);
                for (NodeTuple actionTuple : ((MappingNode)actionNode).getValue()) {
                    String actionTupleKey = ((ScalarNode)actionTuple.getKeyNode()).getValue();
                    if (!actionTupleKey.equals(TemplateResolver.TRAIT_USE_KEY)) continue;
                    SequenceNode sequence = this.cloneSequenceNode((SequenceNode)actionTuple.getValueNode(), new HashMap<String, String>());
                    traitsReference.put(this.normalizeKey(key), sequence);
                    this.removeParametersFromTraitsCall(actionTuple);
                }
            }
            if (!traitsReference.isEmpty()) {
                for (Map.Entry actionEntry : traitsReference.entrySet()) {
                    String actionName = (String)actionEntry.getKey();
                    if (actionName.equals(TemplateResolver.ALL_ACTIONS)) continue;
                    this.applyTraitsToActions((SequenceNode)actionEntry.getValue(), actionNodes, actionName);
                }
                if (traitsReference.get(TemplateResolver.ALL_ACTIONS) != null && typeReference == null) {
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(TemplateResolver.ALL_ACTIONS), actionNodes, null);
                }
            }
            if (typeReference != null) {
                MappingNode clone = this.cloneTemplate(typeReference, TemplateType.RESOURCE_TYPE);
                if (clone == null) {
                    return false;
                }
                for (Map.Entry<String, Node> entry : actionNodes.entrySet()) {
                    if (globalActionNodes.containsKey(entry.getKey())) continue;
                    globalActionNodes.put(entry.getKey(), entry.getValue());
                }
                this.mergeTemplatesIfNeeded(clone, actionNodes);
                if (traitsReference.get(TemplateResolver.ALL_ACTIONS) != null) {
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(TemplateResolver.ALL_ACTIONS), actionNodes, null);
                }
                this.mergeNodes((Node)resourceNode, (Node)clone, Resource.class);
            }
            return !traitsReference.isEmpty() || typeReference != null;
        }

        private void removeParametersFromTraitsCall(NodeTuple traitsNodeTuple) {
            if (traitsNodeTuple.getValueNode().getNodeId() == NodeId.sequence) {
                for (Node traitNode : ((SequenceNode)traitsNodeTuple.getValueNode()).getValue()) {
                    if (traitNode.getNodeId() != NodeId.mapping) continue;
                    this.removeParametersFromTemplateCall((NodeTuple)((MappingNode)traitNode).getValue().get(0));
                }
            }
        }

        private void removeParametersFromTemplateCall(NodeTuple typeNodeTuple) {
            if (typeNodeTuple.getValueNode().getNodeId() == NodeId.mapping) {
                NodeTuple typeParamTuple = (NodeTuple)((MappingNode)typeNodeTuple.getValueNode()).getValue().get(0);
                try {
                    Field value = typeNodeTuple.getClass().getDeclaredField("valueNode");
                    value.setAccessible(true);
                    value.set(typeNodeTuple, typeParamTuple.getKeyNode());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private Node setTupleValueToEmptyMappingNode(NodeTuple tuple) {
            try {
                Field value = tuple.getClass().getDeclaredField("valueNode");
                value.setAccessible(true);
                MappingNode mappingNode = new MappingNode(Tag.MAP, new ArrayList(), Boolean.valueOf(false));
                value.set(tuple, mappingNode);
                return mappingNode;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void applyTraitsToActions(SequenceNode traits, Map<String, Node> actionNodes, String actionName) {
            for (Node ref : traits.getValue()) {
                if (actionName == null) {
                    for (Map.Entry<String, Node> actionEntry : actionNodes.entrySet()) {
                        this.currentAction = actionEntry.getKey();
                        MappingNode templateNode = this.cloneTemplate(ref, TemplateType.TRAIT);
                        if (templateNode == null) continue;
                        this.mergeNodes(actionEntry.getValue(), (Node)templateNode, Action.class);
                    }
                    continue;
                }
                this.currentAction = actionName;
                MappingNode templateNode = this.cloneTemplate(ref, TemplateType.TRAIT);
                if (templateNode == null) continue;
                this.mergeNodes(actionNodes.get(actionName), (Node)templateNode, Action.class);
            }
        }

        private MappingNode cloneTemplate(Node reference, TemplateType type) {
            String label;
            Map<String, MappingNode> templateMap;
            String templateName = this.getTemplateName(reference);
            HashMap<String, String> defaultParameters = new HashMap<String, String>();
            defaultParameters.put("resourcePath", this.relativeUri);
            defaultParameters.put("resourcePathName", this.getResourcePathName(this.fullUri));
            if (type == TemplateType.RESOURCE_TYPE) {
                templateMap = TemplateResolver.this.getResourceTypesMap();
                label = "resource type";
            } else {
                templateMap = TemplateResolver.this.getTraitsMap();
                label = "trait";
                defaultParameters.put("methodName", this.currentAction);
            }
            MappingNode templateNode = templateMap.get(templateName);
            if (templateNode == null) {
                this.addError(label + " not defined: " + templateName);
                return null;
            }
            return this.cloneMappingNode(templateNode, this.getTemplateParameters(reference, defaultParameters));
        }

        private String getResourcePathName(String fullUri) {
            String[] paths = fullUri.split("/");
            for (int i = paths.length - 1; i >= 0; --i) {
                if (paths[i].contains("{") || paths[i].length() <= 0) continue;
                return paths[i];
            }
            return "";
        }

        private void addError(String message) {
            this.templateValidations.add(ValidationResult.createErrorResult(message));
        }

        private void addError(String message, Node node) {
            this.templateValidations.add(ValidationResult.createErrorResult(message, node.getStartMark(), node.getEndMark()));
        }

        private Map<String, String> getTemplateParameters(Node node, Map<String, String> parameters) {
            if (node.getNodeId() == NodeId.mapping) {
                List tuples = ((MappingNode)node).getValue();
                Node params = ((NodeTuple)tuples.get(0)).getValueNode();
                for (NodeTuple paramTuple : ((MappingNode)params).getValue()) {
                    String paramKey = ((ScalarNode)paramTuple.getKeyNode()).getValue();
                    String paramValue = ((ScalarNode)paramTuple.getValueNode()).getValue();
                    parameters.put(paramKey, paramValue);
                }
            }
            return parameters;
        }

        private String getTemplateName(Node templateReferenceNode) {
            Node templateNameNode = templateReferenceNode;
            if (templateReferenceNode.getNodeId() == NodeId.mapping) {
                templateNameNode = ((NodeTuple)((MappingNode)templateReferenceNode).getValue().get(0)).getKeyNode();
            }
            return ((ScalarNode)templateNameNode).getValue();
        }

        private void removeOptionalNodes(MappingNode node, boolean isResourceNode) {
            for (NodeTuple tuple : new ArrayList(node.getValue())) {
                String keyValue = ((ScalarNode)tuple.getKeyNode()).getValue();
                if (isResourceNode && keyValue.startsWith("/")) continue;
                if (this.isOptional(keyValue)) {
                    node.getValue().remove(tuple);
                    continue;
                }
                if (tuple.getValueNode().getNodeId() != NodeId.mapping) continue;
                this.removeOptionalNodes((MappingNode)tuple.getValueNode(), false);
            }
        }

        private MappingNode cloneMappingNode(MappingNode node, Map<String, String> parameters) {
            ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
            for (NodeTuple tuple : node.getValue()) {
                if (tuple.getKeyNode().getNodeId() != NodeId.scalar) {
                    this.addError("Only scalar keys are allowed", tuple.getKeyNode());
                    break;
                }
                ScalarNode key = this.cloneScalarNode((ScalarNode)tuple.getKeyNode(), parameters);
                Node value = this.cloneNode(tuple.getValueNode(), parameters);
                tuples.add(new NodeTuple((Node)key, value));
            }
            return new MappingNode(node.getTag(), tuples, node.getFlowStyle());
        }

        private Node cloneNode(Node valueNode, Map<String, String> parameters) {
            if (valueNode.getNodeId() == NodeId.mapping) {
                return this.cloneMappingNode((MappingNode)valueNode, parameters);
            }
            if (valueNode.getNodeId() == NodeId.sequence) {
                return this.cloneSequenceNode((SequenceNode)valueNode, parameters);
            }
            if (valueNode.getNodeId() == NodeId.scalar) {
                return this.cloneScalarNode((ScalarNode)valueNode, parameters);
            }
            this.addError("unsupported node type: " + valueNode.getNodeId());
            return null;
        }

        private SequenceNode cloneSequenceNode(SequenceNode node, Map<String, String> parameters) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node item : node.getValue()) {
                nodes.add(this.cloneNode(item, parameters));
            }
            return new SequenceNode(node.getTag(), nodes, node.getFlowStyle());
        }

        private ScalarNode cloneScalarNode(ScalarNode node, Map<String, String> parameters) {
            Pattern pattern = Pattern.compile("<<[^>]+>>");
            String value = node.getValue();
            Matcher matcher = pattern.matcher(value);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                sb.append(this.resolveParameter(matcher.group(), parameters));
            }
            matcher.appendTail(sb);
            return new ScalarNode(node.getTag(), sb.toString(), node.getStartMark(), node.getEndMark(), node.getStyle());
        }

        private String resolveParameter(String match, Map<String, String> parameters) {
            String[] tokens;
            String result = "";
            for (String token : tokens = match.substring(2, match.length() - 2).split("\\|")) {
                if (parameters.containsKey(token = token.trim())) {
                    result = parameters.get(token);
                    continue;
                }
                if (token.startsWith("!")) {
                    try {
                        Method method = Inflector.class.getMethod(token.substring(1), String.class);
                        result = (String)method.invoke(null, result);
                    }
                    catch (Exception e) {
                        this.addError("Invalid parameter function: " + token);
                    }
                    continue;
                }
                this.addError("Invalid parameter definition: " + match);
            }
            return result;
        }

        private MappingNode mergeMappingNodes(MappingNode baseNode, MappingNode templateNode, Class<?> context) {
            Map<String, NodeTuple> baseTupleMap = this.getTupleMap(baseNode);
            for (NodeTuple templateTuple : templateNode.getValue()) {
                String templateKey = ((ScalarNode)templateTuple.getKeyNode()).getValue();
                if (this.nonMergeableFields(context).contains(templateKey)) continue;
                String baseKey = this.getMatchingKey(baseTupleMap, templateKey);
                if (baseKey == null) {
                    baseNode.getValue().add(templateTuple);
                    continue;
                }
                Node keyNode = baseTupleMap.get(baseKey).getKeyNode();
                if (this.isOptional(baseKey) && !this.isOptional(templateKey)) {
                    keyNode = templateTuple.getKeyNode();
                }
                Node baseInnerNode = baseTupleMap.get(baseKey).getValueNode();
                Node templateInnerNode = templateTuple.getValueNode();
                Node valueNode = this.mergeNodes(baseInnerNode, templateInnerNode, this.pushMergeContext(context, baseKey));
                baseNode.getValue().remove(baseTupleMap.get(baseKey));
                baseNode.getValue().add(new NodeTuple(keyNode, valueNode));
            }
            return baseNode;
        }

        private Class<?> pushMergeContext(Class<?> context, String key) {
            if (context.equals(Resource.class) && this.isAction(key)) {
                return Action.class;
            }
            return Object.class;
        }

        private Node mergeNodes(Node baseNode, Node templateNode, Class<?> context) {
            if (baseNode.getNodeId() == NodeId.mapping && templateNode.getNodeId() == NodeId.mapping) {
                return this.mergeMappingNodes((MappingNode)baseNode, (MappingNode)templateNode, context);
            }
            if (templateNode.getNodeId() == NodeId.mapping) {
                return this.cleanMergedTuples((MappingNode)templateNode, context);
            }
            return baseNode;
        }

        private MappingNode cleanMergedTuples(MappingNode templateNode, Class<?> context) {
            ArrayList tuples = new ArrayList(templateNode.getValue());
            for (NodeTuple tuple : tuples) {
                String key = ((ScalarNode)tuple.getKeyNode()).getValue();
                if (!this.nonMergeableFields(context).contains(key)) continue;
                templateNode.getValue().remove(tuple);
            }
            return templateNode;
        }

        private Set nonMergeableFields(Class<?> element) {
            String[] fields = new String[]{};
            if (element.equals(Resource.class)) {
                fields = new String[]{"usage", "summary", "displayName", TemplateResolver.RESOURCE_TYPE_USE_KEY, TemplateResolver.TRAIT_USE_KEY};
            } else if (element.equals(Action.class)) {
                fields = new String[]{"usage", "summary", "displayName", TemplateResolver.TRAIT_USE_KEY};
            }
            return new HashSet<String>(Arrays.asList(fields));
        }

        private boolean isAction(String key) {
            try {
                ActionType.valueOf(this.normalizeKey(key).toUpperCase());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        private boolean isOptional(String key) {
            return key.endsWith(TemplateResolver.OPTIONAL_MODIFIER);
        }

        private String getMatchingKey(Map<String, NodeTuple> tupleMap, String key) {
            key = this.normalizeKey(key);
            for (String resourceKey : tupleMap.keySet()) {
                if (!this.normalizeKey(resourceKey).equals(key)) continue;
                return resourceKey;
            }
            return null;
        }

        private String normalizeKey(String key) {
            if (key.endsWith(TemplateResolver.OPTIONAL_MODIFIER)) {
                return key.substring(0, key.length() - 1);
            }
            return key;
        }

        private Map<String, NodeTuple> getTupleMap(MappingNode mappingNode) {
            HashMap<String, NodeTuple> tupleMap = new HashMap<String, NodeTuple>();
            for (NodeTuple tuple : mappingNode.getValue()) {
                tupleMap.put(((ScalarNode)tuple.getKeyNode()).getValue(), tuple);
            }
            return tupleMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TemplateType {
        RESOURCE_TYPE,
        TRAIT;

    }
}

