/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.util.Stack;
import org.apache.commons.lang.ArrayUtils;
import org.raml.model.Raml;
import org.raml.model.Resource;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.IncludeResolver;
import org.raml.parser.tagresolver.JacksonTagResolver;
import org.raml.parser.tagresolver.JaxbTagResolver;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.MediaTypeResolver;
import org.raml.parser.visitor.TemplateResolver;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlDocumentBuilder;
import org.yaml.snakeyaml.nodes.MappingNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RamlDocumentBuilder
extends YamlDocumentBuilder<Raml> {
    private TemplateResolver templateResolver;
    private MediaTypeResolver mediaTypeResolver;

    public RamlDocumentBuilder() {
        this(new DefaultResourceLoader(), new TagResolver[0]);
    }

    public RamlDocumentBuilder(ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        super(Raml.class, resourceLoader, RamlDocumentBuilder.defaultResolver(tagResolvers));
    }

    private static TagResolver[] defaultResolver(TagResolver[] tagResolvers) {
        Object[] defaultResolvers = new TagResolver[]{new IncludeResolver(), new JacksonTagResolver(), new JaxbTagResolver()};
        return (TagResolver[])ArrayUtils.addAll((Object[])defaultResolvers, (Object[])tagResolvers);
    }

    @Override
    public void onMappingNodeStart(MappingNode mappingNode, TupleType tupleType) {
        super.onMappingNodeStart(mappingNode, tupleType);
        if (this.getDocumentContext().peek() instanceof Resource) {
            Resource resource = (Resource)this.getDocumentContext().peek();
            this.getTemplateResolver().resolve(mappingNode, resource.getRelativeUri(), resource.getUri());
        } else if (this.isBodyBuilder(this.getBuilderContext().peek())) {
            this.getMediaTypeResolver().resolve(mappingNode);
        }
    }

    private String toString(Stack<NodeBuilder<?>> builderContext) {
        StringBuilder builder = new StringBuilder(">>> BuilderContext >>> ");
        for (NodeBuilder nodeBuilder : builderContext) {
            builder.append(nodeBuilder).append(" ->- ");
        }
        return builder.toString();
    }

    private boolean isBodyBuilder(NodeBuilder builder) {
        try {
            Field valueType = builder.getClass().getDeclaredField("valueClass");
            valueType.setAccessible(true);
            return valueType.get(builder) != null && ((Class)valueType.get(builder)).getName().equals("org.raml.model.MimeType");
        }
        catch (NoSuchFieldException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    public TemplateResolver getTemplateResolver() {
        if (this.templateResolver == null) {
            this.templateResolver = new TemplateResolver(this.getResourceLoader(), this);
        }
        return this.templateResolver;
    }

    public MediaTypeResolver getMediaTypeResolver() {
        if (this.mediaTypeResolver == null) {
            this.mediaTypeResolver = new MediaTypeResolver();
        }
        return this.mediaTypeResolver;
    }

    @Override
    protected void preBuildProcess() {
        this.getTemplateResolver().init(this.getRootNode());
        this.getMediaTypeResolver().beforeDocumentStart(this.getRootNode());
    }

    @Override
    protected void postBuildProcess() {
    }
}

