/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.raml.parser.visitor.IncludeInfo;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationResult {
    private Level level;
    private String message;
    private Mark startMark;
    private Mark endMark;
    private Deque<IncludeInfo> includeContext;

    private ValidationResult(Level level, String message, Mark startMark, Mark endMark) {
        this.level = level;
        this.message = message;
        this.startMark = startMark;
        this.endMark = endMark;
    }

    public boolean isValid() {
        return this.level != Level.ERROR;
    }

    public String getMessage() {
        return this.message;
    }

    public static ValidationResult createErrorResult(String message, Mark startMark, Mark endMark) {
        return new ValidationResult(Level.ERROR, message, startMark, endMark);
    }

    public static ValidationResult createErrorResult(String message, Node node) {
        return ValidationResult.createErrorResult(message, node.getStartMark(), node.getEndMark());
    }

    public static ValidationResult createErrorResult(String message) {
        return ValidationResult.createErrorResult(message, null, null);
    }

    public static ValidationResult create(Level level, String message) {
        return new ValidationResult(level, message, null, null);
    }

    public Mark getStartMark() {
        return this.startMark;
    }

    public Mark getEndMark() {
        return this.endMark;
    }

    public String getIncludeName() {
        if (this.includeContext.isEmpty()) {
            return null;
        }
        return this.includeContext.peek().getIncludeName();
    }

    public Deque<IncludeInfo> getIncludeContext() {
        return this.includeContext;
    }

    public void setIncludeContext(Deque<IncludeInfo> includeContext) {
        this.includeContext = new ArrayDeque<IncludeInfo>(includeContext);
    }

    public static boolean areValid(List<ValidationResult> validationResults) {
        for (ValidationResult result : validationResults) {
            if (result.isValid()) continue;
            return false;
        }
        return true;
    }

    public static List<ValidationResult> getLevel(Level level, List<ValidationResult> results) {
        ArrayList<ValidationResult> filtered = new ArrayList<ValidationResult>();
        for (ValidationResult result : results) {
            if (result.level != level) continue;
            filtered.add(result);
        }
        return filtered;
    }

    public String toString() {
        return "ValidationResult{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        ERROR,
        WARN,
        INFO;

    }
}

