/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.CompositeHandler;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.YamlValidator;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlValidationService {
    private List<ValidationResult> errorMessage;
    private YamlValidator[] yamlValidators;
    private ResourceLoader resourceLoader;
    private NodeHandler nodeHandler;

    protected YamlValidationService(YamlValidator ... yamlValidators) {
        this(new DefaultResourceLoader(), yamlValidators);
    }

    protected YamlValidationService(ResourceLoader resourceLoader, YamlValidator ... yamlValidators) {
        this.resourceLoader = resourceLoader;
        this.yamlValidators = yamlValidators;
        this.errorMessage = new ArrayList<ValidationResult>();
        this.nodeHandler = new CompositeHandler(yamlValidators);
    }

    public List<ValidationResult> validate(String content) {
        Yaml yamlParser = new Yaml();
        try {
            NodeVisitor nodeVisitor = new NodeVisitor(this.nodeHandler, this.resourceLoader);
            Node root = yamlParser.compose(new StringReader(content));
            this.errorMessage.addAll(this.preValidation((MappingNode)root));
            if (this.errorMessage.isEmpty() && root.getNodeId() == NodeId.mapping) {
                nodeVisitor.visitDocument((MappingNode)root);
            }
        }
        catch (YAMLException ex) {
            // empty catch block
        }
        for (YamlValidator yamlValidator : this.yamlValidators) {
            this.errorMessage.addAll(yamlValidator.getMessages());
        }
        return this.errorMessage;
    }

    protected List<ValidationResult> preValidation(MappingNode root) {
        return new ArrayList<ValidationResult>();
    }
}

