/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.IncludeResolver;
import org.raml.parser.visitor.NodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateResolver {
    public static final String OPTIONAL_MODIFIER = "?";
    public static final String ALL_ACTIONS = "*";
    public static final String TRAIT_USE_KEY = "is";
    public static final String RESOURCE_TYPE_USE_KEY = "type";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IncludeResolver includeResolver = new IncludeResolver();
    private Map<String, MappingNode> resourceTypesMap = new HashMap<String, MappingNode>();
    private Map<String, MappingNode> traitsMap = new HashMap<String, MappingNode>();
    private ResourceLoader resourceLoader;
    private NodeHandler nodeNandler;

    public TemplateResolver(ResourceLoader resourceLoader, NodeHandler nodeNandler) {
        this.resourceLoader = resourceLoader;
        this.nodeNandler = nodeNandler;
    }

    public Map<String, MappingNode> getResourceTypesMap() {
        return this.resourceTypesMap;
    }

    public Map<String, MappingNode> getTraitsMap() {
        return this.traitsMap;
    }

    public List<ValidationResult> init(MappingNode rootNode) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (rootNode == null) {
            validationResults.add(ValidationResult.createErrorResult("Invalid Root Node"));
            return validationResults;
        }
        for (int i = 0; i < rootNode.getValue().size(); ++i) {
            NodeTuple rootTuple = rootNode.getValue().get(i);
            String key = ((ScalarNode)rootTuple.getKeyNode()).getValue();
            if (!key.equals("resourceTypes") && !key.equals("traits")) continue;
            Node templateSequence = rootTuple.getValueNode();
            if (templateSequence.getNodeId() == NodeId.scalar) {
                if (!templateSequence.getTag().startsWith("!include")) {
                    validationResults.add(ValidationResult.createErrorResult("Sequence or !include expected", templateSequence.getStartMark(), templateSequence.getEndMark()));
                }
                templateSequence = this.includeResolver.resolveInclude((ScalarNode)templateSequence, this.resourceLoader, this.nodeNandler);
                rootNode.getValue().remove(i);
                rootNode.getValue().add(i, new NodeTuple(rootTuple.getKeyNode(), templateSequence));
            }
            this.loopTemplateSequence((SequenceNode)templateSequence, key, validationResults);
        }
        return validationResults;
    }

    private void loopTemplateSequence(SequenceNode templateSequence, String templateType, List<ValidationResult> validationResults) {
        ArrayList<Node> prunedTmplates = new ArrayList<Node>();
        for (int j = 0; j < templateSequence.getValue().size(); ++j) {
            Node template = templateSequence.getValue().get(j);
            if (template.getNodeId() == NodeId.scalar) {
                if (!template.getTag().startsWith("!include")) {
                    validationResults.add(ValidationResult.createErrorResult("Mapping or !include expected", templateSequence.getStartMark(), templateSequence.getEndMark()));
                }
                template = this.includeResolver.resolveInclude((ScalarNode)template, this.resourceLoader, this.nodeNandler);
            }
            for (NodeTuple tuple : ((MappingNode)template).getValue()) {
                String templateKey = ((ScalarNode)tuple.getKeyNode()).getValue();
                MappingNode templateNode = (MappingNode)tuple.getValueNode();
                if (templateType.equals("resourceTypes")) {
                    this.resourceTypesMap.put(templateKey, templateNode);
                }
                if (templateType.equals("traits")) {
                    this.traitsMap.put(templateKey, templateNode);
                }
                prunedTmplates.add(this.getFakeTemplateNode(tuple.getKeyNode()));
            }
        }
        templateSequence.getValue().clear();
        templateSequence.getValue().addAll(prunedTmplates);
    }

    private Node getFakeTemplateNode(Node keyNode) {
        ArrayList<NodeTuple> innerTuples = new ArrayList<NodeTuple>();
        innerTuples.add(new NodeTuple(new ScalarNode(Tag.STR, "displayName", null, null, null), keyNode));
        MappingNode innerNode = new MappingNode(Tag.MAP, innerTuples, false);
        ArrayList<NodeTuple> outerTuples = new ArrayList<NodeTuple>();
        outerTuples.add(new NodeTuple(keyNode, innerNode));
        return new MappingNode(Tag.MAP, outerTuples, false);
    }

    public List<ValidationResult> resolve(MappingNode resourceNode) {
        ArrayList<ValidationResult> templateValidations = new ArrayList<ValidationResult>();
        return new ResourceTemplateMerger(templateValidations, resourceNode).merge();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceTemplateMerger {
        private List<ValidationResult> templateValidations;
        private MappingNode resourceNode;

        public ResourceTemplateMerger(List<ValidationResult> templateValidations, MappingNode resourceNode) {
            this.templateValidations = templateValidations;
            this.resourceNode = resourceNode;
        }

        public List<ValidationResult> merge() {
            this.mergeTemplatesIfNeeded(this.resourceNode, new HashMap<String, Node>());
            this.removeOptionalNodes(this.resourceNode);
            return this.templateValidations;
        }

        private void mergeTemplatesIfNeeded(MappingNode resourceNode, Map<String, Node> globalActionNodes) {
            Node typeReference = null;
            HashMap<String, SequenceNode> traitsReference = new HashMap<String, SequenceNode>();
            HashMap<String, Node> actionNodes = new HashMap<String, Node>(globalActionNodes);
            for (NodeTuple resourceTuple : resourceNode.getValue()) {
                String key = ((ScalarNode)resourceTuple.getKeyNode()).getValue();
                if (key.equals(TemplateResolver.RESOURCE_TYPE_USE_KEY)) {
                    typeReference = resourceTuple.getValueNode();
                    continue;
                }
                if (key.equals(TemplateResolver.TRAIT_USE_KEY)) {
                    traitsReference.put(TemplateResolver.ALL_ACTIONS, (SequenceNode)resourceTuple.getValueNode());
                    continue;
                }
                if (!this.isAction(key)) continue;
                Node actionNode = resourceTuple.getValueNode();
                if (actionNode.getNodeId() != NodeId.mapping) {
                    actionNode = this.setTupleValueToEmptyMappingNode(resourceTuple);
                }
                actionNodes.put(this.normalizeKey(key), actionNode);
                for (NodeTuple actionTuple : ((MappingNode)actionNode).getValue()) {
                    String actionTupleKey = ((ScalarNode)actionTuple.getKeyNode()).getValue();
                    if (!actionTupleKey.equals(TemplateResolver.TRAIT_USE_KEY)) continue;
                    traitsReference.put(this.normalizeKey(key), (SequenceNode)actionTuple.getValueNode());
                }
            }
            if (!traitsReference.isEmpty()) {
                for (String actionName : traitsReference.keySet()) {
                    if (actionName.equals(TemplateResolver.ALL_ACTIONS)) continue;
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(actionName), actionNodes, actionName);
                }
                if (traitsReference.get(TemplateResolver.ALL_ACTIONS) != null && typeReference == null) {
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(TemplateResolver.ALL_ACTIONS), actionNodes, null);
                }
            }
            if (typeReference != null) {
                MappingNode clone = this.cloneTemplate(typeReference, TemplateType.RESOURCE_TYPE);
                if (clone == null) {
                    return;
                }
                for (String key : actionNodes.keySet()) {
                    if (globalActionNodes.containsKey(key)) continue;
                    globalActionNodes.put(key, actionNodes.get(key));
                }
                this.mergeTemplatesIfNeeded(clone, actionNodes);
                if (traitsReference.get(TemplateResolver.ALL_ACTIONS) != null) {
                    this.applyTraitsToActions((SequenceNode)traitsReference.get(TemplateResolver.ALL_ACTIONS), actionNodes, null);
                }
                this.mergeNodes(resourceNode, clone, Resource.class);
            }
        }

        private Node setTupleValueToEmptyMappingNode(NodeTuple tuple) {
            try {
                Field value = tuple.getClass().getDeclaredField("valueNode");
                value.setAccessible(true);
                MappingNode mappingNode = new MappingNode(Tag.MAP, new ArrayList<NodeTuple>(), false);
                value.set(tuple, mappingNode);
                return mappingNode;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void applyTraitsToActions(SequenceNode traits, Map<String, Node> actionNodes, String actionName) {
            for (Node ref : traits.getValue()) {
                MappingNode clone = this.cloneTemplate(ref, TemplateType.TRAIT);
                if (actionName == null) {
                    for (Node actionNode : actionNodes.values()) {
                        this.mergeNodes(actionNode, clone, Action.class);
                    }
                    continue;
                }
                this.mergeNodes(actionNodes.get(actionName), clone, Action.class);
            }
        }

        private MappingNode cloneTemplate(Node reference, TemplateType type) {
            String label;
            Map<String, MappingNode> templateMap;
            String templateName = this.getTemplateName(reference);
            if (type == TemplateType.RESOURCE_TYPE) {
                templateMap = TemplateResolver.this.getResourceTypesMap();
                label = "resource type";
            } else {
                templateMap = TemplateResolver.this.getTraitsMap();
                label = "trait";
            }
            MappingNode templateNode = templateMap.get(templateName);
            if (templateNode == null) {
                this.addError(label + " not defined: " + templateName);
                return null;
            }
            Map<String, String> parameters = this.getTemplateParameters(reference);
            return this.cloneMappingNode(templateNode, parameters);
        }

        private void addError(String message) {
            this.templateValidations.add(ValidationResult.createErrorResult(message));
        }

        private Map<String, String> getTemplateParameters(Node node) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (node.getNodeId() == NodeId.mapping) {
                List<NodeTuple> tuples = ((MappingNode)node).getValue();
                Node params = tuples.get(0).getValueNode();
                for (NodeTuple paramTuple : ((MappingNode)params).getValue()) {
                    String paramKey = ((ScalarNode)paramTuple.getKeyNode()).getValue();
                    String paramValue = ((ScalarNode)paramTuple.getValueNode()).getValue();
                    parameters.put(paramKey, paramValue);
                }
            }
            return parameters;
        }

        private String getTemplateName(Node templateReferenceNode) {
            Node templateNameNode = templateReferenceNode;
            if (templateReferenceNode.getNodeId() == NodeId.mapping) {
                templateNameNode = ((MappingNode)templateReferenceNode).getValue().get(0).getKeyNode();
            }
            return ((ScalarNode)templateNameNode).getValue();
        }

        private void removeOptionalNodes(MappingNode node) {
            for (NodeTuple tuple : new ArrayList<NodeTuple>(node.getValue())) {
                if (this.isOptional(((ScalarNode)tuple.getKeyNode()).getValue())) {
                    node.getValue().remove(tuple);
                    continue;
                }
                if (tuple.getValueNode().getNodeId() != NodeId.mapping) continue;
                this.removeOptionalNodes((MappingNode)tuple.getValueNode());
            }
        }

        private MappingNode cloneMappingNode(MappingNode node, Map<String, String> parameters) {
            ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
            for (NodeTuple tuple : node.getValue()) {
                ScalarNode key = this.cloneScalarNode((ScalarNode)tuple.getKeyNode(), parameters);
                Node value = this.cloneNode(tuple.getValueNode(), parameters);
                tuples.add(new NodeTuple(key, value));
            }
            return new MappingNode(node.getTag(), tuples, node.getFlowStyle());
        }

        private Node cloneNode(Node valueNode, Map<String, String> parameters) {
            if (valueNode.getNodeId() == NodeId.mapping) {
                return this.cloneMappingNode((MappingNode)valueNode, parameters);
            }
            if (valueNode.getNodeId() == NodeId.sequence) {
                return this.cloneSequenceNode((SequenceNode)valueNode, parameters);
            }
            if (valueNode.getNodeId() == NodeId.scalar) {
                return this.cloneScalarNode((ScalarNode)valueNode, parameters);
            }
            this.addError("unsupported node type: " + (Object)((Object)valueNode.getNodeId()));
            return null;
        }

        private SequenceNode cloneSequenceNode(SequenceNode node, Map<String, String> parameters) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node item : node.getValue()) {
                nodes.add(this.cloneNode(item, parameters));
            }
            return new SequenceNode(node.getTag(), nodes, node.getFlowStyle());
        }

        private ScalarNode cloneScalarNode(ScalarNode node, Map<String, String> parameters) {
            String value = node.getValue();
            for (String key : parameters.keySet()) {
                value = value.replaceAll("<<" + key + ">>", parameters.get(key));
            }
            return new ScalarNode(node.getTag(), value, node.getStartMark(), node.getEndMark(), node.getStyle());
        }

        private MappingNode mergeMappingNodes(MappingNode baseNode, MappingNode templateNode, Class<?> context) {
            Map<String, NodeTuple> baseTupleMap = this.getTupleMap(baseNode);
            for (NodeTuple templateTuple : templateNode.getValue()) {
                String templateKey = ((ScalarNode)templateTuple.getKeyNode()).getValue();
                if (this.nonMergeableFields(context).contains(templateKey)) continue;
                String baseKey = this.getMatchingKey(baseTupleMap, templateKey);
                if (baseKey == null) {
                    baseNode.getValue().add(templateTuple);
                    continue;
                }
                Node keyNode = baseTupleMap.get(baseKey).getKeyNode();
                if (this.isOptional(baseKey) && !this.isOptional(templateKey)) {
                    keyNode = templateTuple.getKeyNode();
                }
                Node baseInnerNode = baseTupleMap.get(baseKey).getValueNode();
                Node templateInnerNode = templateTuple.getValueNode();
                Node valueNode = this.mergeNodes(baseInnerNode, templateInnerNode, this.pushMergeContext(context, baseKey));
                baseNode.getValue().remove(baseTupleMap.get(baseKey));
                baseNode.getValue().add(new NodeTuple(keyNode, valueNode));
            }
            return baseNode;
        }

        private Class<?> pushMergeContext(Class<?> context, String key) {
            if (context.equals(Resource.class) && this.isAction(key)) {
                return Action.class;
            }
            return Object.class;
        }

        private Node mergeNodes(Node baseNode, Node templateNode, Class<?> context) {
            if (baseNode.getNodeId() == NodeId.mapping && templateNode.getNodeId() == NodeId.mapping) {
                return this.mergeMappingNodes((MappingNode)baseNode, (MappingNode)templateNode, context);
            }
            if (templateNode.getNodeId() == NodeId.mapping) {
                return this.cleanMergedTuples((MappingNode)templateNode, context);
            }
            return baseNode;
        }

        private MappingNode cleanMergedTuples(MappingNode templateNode, Class<?> context) {
            ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>(templateNode.getValue());
            for (NodeTuple tuple : tuples) {
                String key = ((ScalarNode)tuple.getKeyNode()).getValue();
                if (!this.nonMergeableFields(context).contains(key)) continue;
                templateNode.getValue().remove(tuple);
            }
            return templateNode;
        }

        private Set nonMergeableFields(Class<?> element) {
            String[] fields = new String[]{};
            if (element.equals(Resource.class)) {
                fields = new String[]{"description", "summary", "displayName", TemplateResolver.RESOURCE_TYPE_USE_KEY, TemplateResolver.TRAIT_USE_KEY};
            } else if (element.equals(Action.class)) {
                fields = new String[]{"description", "summary", "displayName", TemplateResolver.TRAIT_USE_KEY};
            }
            return new HashSet<String>(Arrays.asList(fields));
        }

        private boolean isAction(String key) {
            try {
                ActionType.valueOf(this.normalizeKey(key).toUpperCase());
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        private boolean isOptional(String key) {
            return key.endsWith(TemplateResolver.OPTIONAL_MODIFIER);
        }

        private String getMatchingKey(Map<String, NodeTuple> tupleMap, String key) {
            key = this.normalizeKey(key);
            for (String resourceKey : tupleMap.keySet()) {
                if (!this.normalizeKey(resourceKey).equals(key)) continue;
                return resourceKey;
            }
            return null;
        }

        private String normalizeKey(String key) {
            if (key.endsWith(TemplateResolver.OPTIONAL_MODIFIER)) {
                return key.substring(0, key.length() - 1);
            }
            return key;
        }

        private Map<String, NodeTuple> getTupleMap(MappingNode mappingNode) {
            HashMap<String, NodeTuple> tupleMap = new HashMap<String, NodeTuple>();
            for (NodeTuple tuple : mappingNode.getValue()) {
                tupleMap.put(((ScalarNode)tuple.getKeyNode()).getValue(), tuple);
            }
            return tupleMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TemplateType {
        RESOURCE_TYPE,
        TRAIT;

    }
}

