/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class CompositeHandler
implements NodeHandler {
    private NodeHandler[] nodeHandlers;

    public CompositeHandler(NodeHandler ... nodeHandlers) {
        this.nodeHandlers = nodeHandlers;
    }

    public void onMappingNodeStart(MappingNode mappingNode) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onMappingNodeStart(mappingNode);
        }
    }

    public void onMappingNodeEnd(MappingNode mappingNode) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onMappingNodeEnd(mappingNode);
        }
    }

    public void onSequenceStart(SequenceNode node, TupleType tupleType) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onSequenceStart(node, tupleType);
        }
    }

    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onSequenceEnd(node, tupleType);
        }
    }

    public void onScalar(ScalarNode node, TupleType tupleType) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onScalar(node, tupleType);
        }
    }

    public void onDocumentStart(MappingNode node) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onDocumentStart(node);
        }
    }

    public void onDocumentEnd(MappingNode node) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onDocumentEnd(node);
        }
    }

    public void onTupleEnd(NodeTuple nodeTuple) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onTupleEnd(nodeTuple);
        }
    }

    public void onTupleStart(NodeTuple nodeTuple) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onTupleStart(nodeTuple);
        }
    }

    public void onSequenceElementStart(Node sequenceNode) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onSequenceElementStart(sequenceNode);
        }
    }

    public void onSequenceElementEnd(Node sequenceNode) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onSequenceElementEnd(sequenceNode);
        }
    }

    public void onIncludeResourceNotFound(ScalarNode node) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onIncludeResourceNotFound(node);
        }
    }

    public void onIncludeStart(String includeName) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onIncludeStart(includeName);
        }
    }

    public void onIncludeEnd(String includeName) {
        for (NodeHandler nh : this.nodeHandlers) {
            nh.onIncludeEnd(includeName);
        }
    }
}

