/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.raml.parser.loader.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceLoader
implements ResourceLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File parentPath;

    public FileResourceLoader(String path) {
        this(new File(path));
    }

    public FileResourceLoader(File path) {
        this.parentPath = path;
    }

    public InputStream fetchResource(String resourceName) {
        File includedFile = new File(this.parentPath, resourceName);
        InputStream inputStream = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Looking for resource: %s on directory: %s...", resourceName, this.parentPath));
        }
        try {
            return new FileInputStream(includedFile);
        }
        catch (FileNotFoundException e) {
            return inputStream;
        }
    }
}

