/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.resolver.DefaultTupleHandler;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.NodeRule;
import org.raml.parser.rule.SequenceRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationResult;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDocumentValidator
implements NodeHandler {
    private Class<?> documentClass;
    private Stack<NodeRule<?>> ruleContext = new Stack();
    private List<ValidationResult> errorMessage = new ArrayList<ValidationResult>();
    private ResourceLoader resourceLoader;

    public YamlDocumentValidator(Class<?> documentClass) {
        this(documentClass, new DefaultResourceLoader());
    }

    public YamlDocumentValidator(Class<?> documentClass, ResourceLoader resourceLoader) {
        this.documentClass = documentClass;
        this.resourceLoader = resourceLoader;
    }

    public List<ValidationResult> validate(String content) {
        Yaml yamlParser = new Yaml();
        try {
            NodeVisitor nodeVisitor = new NodeVisitor(this, this.resourceLoader);
            for (Node data : yamlParser.composeAll(new StringReader(content))) {
                if (!(data instanceof MappingNode)) continue;
                nodeVisitor.visitDocument((MappingNode)data);
            }
        }
        catch (YAMLException yAMLException) {
            // empty catch block
        }
        return this.errorMessage;
    }

    @Override
    public void onMappingNodeStart(MappingNode mappingNode) {
    }

    @Override
    public void onMappingNodeEnd(MappingNode mappingNode) {
    }

    @Override
    public void onSequenceStart(SequenceNode node, TupleType tupleType) {
        List<ValidationResult> result = new ArrayList<ValidationResult>();
        SequenceRule peek = (SequenceRule)((Object)this.ruleContext.peek());
        switch (tupleType) {
            case VALUE: {
                result = ((NodeRule)((Object)peek)).validateValue(node);
            }
        }
        this.addErrorMessageIfRequired(node, result);
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        List<ValidationResult> result;
        NodeRule<?> peek = this.ruleContext.peek();
        switch (tupleType) {
            case VALUE: {
                result = peek.validateValue(node);
                break;
            }
            default: {
                result = ((TupleRule)peek).validateKey(node);
            }
        }
        this.addErrorMessageIfRequired(node, result);
    }

    private void addErrorMessageIfRequired(Node node, List<ValidationResult> result) {
        for (ValidationResult validationResult : result) {
            if (validationResult.isValid()) continue;
            this.errorMessage.add(validationResult);
        }
    }

    @Override
    public void onDocumentStart(MappingNode node) {
        this.ruleContext.push(this.buildDocumentRule());
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        NodeRule<?> pop = this.ruleContext.pop();
        List<ValidationResult> onRuleEnd = pop.onRuleEnd();
        this.addErrorMessageIfRequired(node, onRuleEnd);
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        NodeRule<?> rule = this.ruleContext.pop();
        if (rule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        List<ValidationResult> onRuleEnd = rule.onRuleEnd();
        this.addErrorMessageIfRequired(nodeTuple.getKeyNode(), onRuleEnd);
    }

    @Override
    public void onTupleStart(NodeTuple nodeTuple) {
        TupleRule tupleRule = (TupleRule)this.ruleContext.peek();
        if (tupleRule == null) {
            throw new IllegalStateException("Unexpected ruleContext state");
        }
        TupleRule<?, ?> rule = tupleRule.getRuleForTuple(nodeTuple);
        this.ruleContext.push(rule);
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
        SequenceRule peek = (SequenceRule)((Object)this.ruleContext.peek());
        this.ruleContext.push(peek.getItemRule());
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
        NodeRule<?> rule = this.ruleContext.pop();
        List<ValidationResult> validationResults = rule.onRuleEnd();
        this.addErrorMessageIfRequired(sequenceNode, validationResults);
    }

    @Override
    public void onIncludeResourceNotFound(ScalarNode node) {
        this.addErrorMessageIfRequired(node, Arrays.asList(ValidationResult.createErrorResult("Include can not be resolved " + node.getValue(), node.getStartMark(), node.getEndMark())));
    }

    private DefaultTupleRule<Node, MappingNode> buildDocumentRule() {
        DefaultTupleRule<Node, MappingNode> documentRule = new DefaultTupleRule<Node, MappingNode>(null, new DefaultTupleHandler());
        documentRule.addRulesFor(this.documentClass);
        return documentRule;
    }
}

