/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.utils;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang.ClassUtils;
import org.raml.parser.utils.BooleanConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertUtils {
    private static BooleanConverter booleanConverter = new BooleanConverter();

    public static <T> T convertTo(String value, Class<T> type) {
        if (type.isEnum()) {
            return type.cast(Enum.valueOf(type, value.toUpperCase()));
        }
        Class wrapperClass = type;
        if (type.isPrimitive()) {
            wrapperClass = ClassUtils.primitiveToWrapper(type);
        }
        if (wrapperClass.getName().equals(Boolean.class.getName())) {
            return wrapperClass.cast(booleanConverter.convert(Boolean.class, value));
        }
        return wrapperClass.cast(org.apache.commons.beanutils.ConvertUtils.convert((String)value, (Class)type));
    }

    public static boolean canBeConverted(String value, Class<?> type) {
        if (type.isEnum()) {
            ?[] enumConstants;
            for (Object enumConstant : enumConstants = type.getEnumConstants()) {
                if (!enumConstant.toString().equals(value.toUpperCase())) continue;
                return true;
            }
            return false;
        }
        if (type.isInstance(value)) {
            return true;
        }
        try {
            Class wrapperClass = ClassUtils.primitiveToWrapper(type);
            ConvertUtils.convertTo(value, wrapperClass);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (ConversionException e) {
            return false;
        }
    }
}

