/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import java.util.HashMap;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.PojoTupleBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTupleBuilder
extends DefaultTupleBuilder<ScalarNode, MappingNode> {
    private Class<?> keyClass;
    private Class valueClass;
    private String keyValue;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MapTupleBuilder(String keyValue, Class<?> keyClass, Class<?> valueClass) {
        super(new DefaultScalarTupleHandler(MappingNode.class, keyValue));
        this.keyValue = keyValue;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
    }

    @Override
    public TupleBuilder getBuiderForTuple(NodeTuple tuple) {
        return new PojoTupleBuilder(this.valueClass);
    }

    @Override
    public Object buildValue(Object parent, MappingNode node) {
        HashMap map = new HashMap();
        ReflectionUtils.setProperty(parent, this.keyValue, map);
        return map;
    }

    @Override
    public void buildKey(Object parent, ScalarNode tuple) {
        this.keyValue = tuple.getValue();
    }
}

