/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.builder;

import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.utils.ReflectionUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoTupleBuilder
extends DefaultTupleBuilder<ScalarNode, Node> {
    private Class<?> pojoClass;
    private String fieldName;

    public PojoTupleBuilder(String fieldName, Class<?> pojoClass) {
        super(new DefaultScalarTupleHandler(MappingNode.class, fieldName));
        this.fieldName = fieldName;
        this.pojoClass = pojoClass;
    }

    public PojoTupleBuilder(Class<?> pojoClass) {
        this(null, pojoClass);
    }

    @Override
    public NodeBuilder getBuiderForTuple(NodeTuple tuple) {
        if (this.builders.isEmpty()) {
            this.addBuildersFor(this.pojoClass);
        }
        return super.getBuiderForTuple(tuple);
    }

    @Override
    public Object buildValue(Object parent, Node node) {
        try {
            Object newValue = this.pojoClass.newInstance();
            ReflectionUtils.setProperty(parent, this.fieldName, newValue);
            this.processPojoAnnotations(newValue, this.fieldName, parent);
            return newValue;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void buildKey(Object parent, ScalarNode node) {
        this.fieldName = node.getValue();
    }
}

