/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.Resource;
import org.raml.model.TraitAction;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trait {
    @Scalar
    private String name;
    @Scalar
    private String description;
    @Mapping
    private Map<String, TraitAction> provides = new HashMap<String, TraitAction>();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, TraitAction> getProvides() {
        return this.provides;
    }

    public void setProvides(Map<String, TraitAction> provides) {
        this.provides = provides;
    }

    public void applyToResource(Resource resource, Set<ActionType> finalActions) {
        for (TraitAction tAction : this.provides.values()) {
            ActionType actionType;
            String tActionTypeName = tAction.getType().toUpperCase();
            if (tActionTypeName.endsWith("?")) {
                tActionTypeName = tActionTypeName.substring(0, tActionTypeName.length() - 1);
            }
            if (!finalActions.contains((Object)(actionType = ActionType.valueOf(tActionTypeName)))) {
                return;
            }
            Action action = resource.getActions().get((Object)actionType);
            if (action == null) {
                resource.getActions().put(actionType, tAction.createAction(resource));
                continue;
            }
            tAction.updateAction(action);
        }
    }
}

