/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.util.List;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.v10.nodes.NativeTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.utils.ResourcePathUtils;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNodeImpl;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.phase.Transformer;
import org.raml.yagi.framework.util.NodeSelector;

public class ImplicitUriParametersInjectionTransformer
implements Transformer {
    private static final String URI_PARAMETERS = "uriParameters";

    public boolean matches(Node node) {
        return node instanceof ResourceNode;
    }

    public Node transform(Node node) {
        ResourceNode resourceNode = (ResourceNode)node;
        List<String> templates = ResourcePathUtils.getUriTemplates(resourceNode.getRelativeUri());
        templates.remove("version");
        this.injectImplicitUriParameters(resourceNode.getValue(), templates);
        return node;
    }

    private void injectImplicitUriParameters(Node node, List<String> templates) {
        Node parametersNode = NodeSelector.selectFrom((String)URI_PARAMETERS, (Node)node);
        if (parametersNode != null) {
            for (Node child : parametersNode.getChildren()) {
                String parameterName = ((SimpleTypeNode)((KeyValueNode)child).getKey()).getLiteralValue();
                templates.remove(parameterName.endsWith("?") ? parameterName.substring(0, parameterName.length() - 1) : parameterName);
            }
            if (!templates.isEmpty()) {
                this.addUriParameters(templates, parametersNode);
            }
        } else if (!templates.isEmpty()) {
            StringNodeImpl uriParameters = new StringNodeImpl(URI_PARAMETERS);
            ObjectNodeImpl objectNode = new ObjectNodeImpl();
            this.addUriParameters(templates, (Node)objectNode);
            node.addChild((Node)new KeyValueNodeImpl((Node)uriParameters, (Node)objectNode));
        }
    }

    private void addUriParameters(List<String> templates, Node objectNode) {
        for (String uriParameter : templates) {
            PropertyNode propertyNode = new PropertyNode();
            propertyNode.addChild((Node)new StringNodeImpl(uriParameter));
            propertyNode.addChild(new NativeTypeExpressionNode("string"));
            objectNode.addChild((Node)propertyNode);
        }
    }
}

