/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.SchemaBasedResolvedType;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class ArrayResolvedType
extends XmlFacetsCapableType {
    private ResolvedType items;
    private Boolean uniqueItems;
    private Integer minItems;
    private Integer maxItems;

    public ArrayResolvedType(TypeExpressionNode node, XmlFacets xmlFacets, ResolvedType items, Boolean uniqueItems, Integer minItems, Integer maxItems, ResolvedCustomFacets customFacets) {
        super(node, xmlFacets, customFacets);
        this.items = items;
        this.uniqueItems = uniqueItems;
        this.minItems = minItems;
        this.maxItems = maxItems;
    }

    public ArrayResolvedType(TypeExpressionNode node, ResolvedType items) {
        this(node);
        this.items = items;
    }

    public ArrayResolvedType(TypeExpressionNode node) {
        super(node, new ResolvedCustomFacets("minItems", "maxItems", "uniqueItems", "items"));
    }

    @Override
    protected ArrayResolvedType copy() {
        return new ArrayResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets().copy(), this.items, this.uniqueItems, this.minItems, this.maxItems, this.customFacets.copy());
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)grammar.uniqueItemsField()).add((Rule)grammar.itemsField()).add((Rule)grammar.minItemsField()).add((Rule)grammar.maxItemsField()).addAll(this.customFacets.getRules());
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        ArrayResolvedType result = this.copy();
        result.customFacets = result.customFacets.overwriteFacets(from);
        result.setMinItems(NodeSelector.selectIntValue((String)"minItems", (Node)from));
        result.setMaxItems(NodeSelector.selectIntValue((String)"maxItems", (Node)from));
        result.setUniqueItems(NodeSelector.selectBooleanValue((String)"uniqueItems", (Node)from));
        Node items = NodeSelector.selectFrom((String)"items", (Node)from);
        if (items != null && items instanceof TypeDeclarationNode) {
            result.setItems(((TypeDeclarationNode)items).getResolvedType());
        }
        this.overwriteFacets(result, from);
        return result;
    }

    @Override
    public boolean doAccept(ResolvedType resolvedType) {
        if (resolvedType instanceof ArrayResolvedType) {
            return this.items.accepts(((ArrayResolvedType)resolvedType).getItems());
        }
        return false;
    }

    @Override
    public void validateState() {
        int max;
        int min = this.minItems != null ? this.minItems : 0;
        int n = max = this.maxItems != null ? this.maxItems : Integer.MAX_VALUE;
        if (max < min) {
            this.getTypeDeclarationNode().replaceWith((Node)RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "maxItems must be greater than or equal to minItems."));
        }
        if (this.getItems() instanceof SchemaBasedResolvedType) {
            this.getTypeDeclarationNode().replaceWith((Node)RamlErrorNodeFactory.createInvalidFacetState(this.getItems().getTypeName(), "array type cannot be of an external type."));
        }
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        ArrayResolvedType result = this.copy();
        if (with instanceof ArrayResolvedType) {
            result.setMinItems(((ArrayResolvedType)with).getMinItems());
            result.setMaxItems(((ArrayResolvedType)with).getMaxItems());
            result.setUniqueItems(((ArrayResolvedType)with).getUniqueItems());
            result.setItems(((ArrayResolvedType)with).getItems());
        }
        result.customFacets = result.customFacets.mergeWith(with.customFacets());
        return this.mergeFacets(result, with);
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitArray(this);
    }

    @Nonnull
    public ResolvedType getItems() {
        if (this.items == null) {
            this.items = new AnyResolvedType(this.getTypeDeclarationNode());
        }
        return this.items;
    }

    private void setItems(ResolvedType items) {
        if (items != null) {
            this.items = items;
        }
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    private void setUniqueItems(Boolean uniqueItems) {
        if (uniqueItems != null) {
            this.uniqueItems = uniqueItems;
        }
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    private void setMinItems(Integer minItems) {
        if (minItems != null) {
            this.minItems = minItems;
        }
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    private void setMaxItems(Integer maxItems) {
        if (maxItems != null) {
            this.maxItems = maxItems;
        }
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.ARRAY.getType();
    }
}

