/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.nodes.RamlTypedFragmentNode;
import org.raml.v2.internal.impl.v10.Raml10Builder;
import org.raml.v2.internal.impl.v10.phase.LibraryLinkingTransformation;
import org.raml.v2.internal.utils.PhaseUtils;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.phase.TransformationPhase;
import org.raml.yagi.framework.phase.Transformer;

public class RamlFragmentGrammarTransformer
implements Transformer {
    private final Raml10Builder builder;
    private final ResourceLoader resourceLoader;

    public RamlFragmentGrammarTransformer(Raml10Builder builder, ResourceLoader resourceLoader) {
        this.builder = builder;
        this.resourceLoader = resourceLoader;
    }

    public boolean matches(Node node) {
        return node instanceof RamlTypedFragmentNode;
    }

    public Node transform(Node node) {
        RamlTypedFragmentNode ramlTypedFragmentNode = (RamlTypedFragmentNode)node;
        Rule rule = RamlHeader.getFragmentRule(ramlTypedFragmentNode.getFragment());
        node = rule.apply(node);
        Node apply = PhaseUtils.applyPhases(node, new Phase[]{new TransformationPhase(new Transformer[]{new LibraryLinkingTransformation(this.builder, this.resourceLoader)})});
        if (apply instanceof RamlTypedFragmentNode) {
            ((RamlTypedFragmentNode)apply).resolveLibraryReference();
        }
        return apply;
    }
}

