/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.yagi.framework.util.NodeSelector;

public class StringResolvedType
extends XmlFacetsCapableType {
    private static final int DEFAULT_MIN_LENGTH = 0;
    private static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    private Integer minLength;
    private Integer maxLength;
    private String pattern;
    private List<String> enums = new ArrayList<String>();

    public StringResolvedType(TypeExpressionNode from) {
        super(from, new ResolvedCustomFacets("minLength", "maxLength", "pattern"));
    }

    public StringResolvedType(TypeExpressionNode declarationNode, XmlFacets xmlFacets, Integer minLength, Integer maxLength, String pattern, List<String> enums, ResolvedCustomFacets customFacets) {
        super(declarationNode, xmlFacets, customFacets);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.pattern = pattern;
        this.enums = enums;
    }

    @Override
    protected StringResolvedType copy() {
        return new StringResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets(), this.minLength, this.maxLength, this.pattern, this.enums, this.customFacets.copy());
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        StringResolvedType result = this.copy();
        result.customFacets = this.customFacets.copy().overwriteFacets(from);
        result.setMinLength(NodeSelector.selectIntValue((String)"minLength", (Node)from));
        result.setMaxLength(NodeSelector.selectIntValue((String)"maxLength", (Node)from));
        result.setPattern(NodeSelector.selectStringValue((String)"pattern", (Node)from));
        result.setEnums(this.getEnumValues(from));
        return this.overwriteFacets(result, from);
    }

    @Nonnull
    private List<String> getEnumValues(Node typeNode) {
        Node values = typeNode.get("enum");
        ArrayList<String> enumValues = new ArrayList<String>();
        if (values != null && values instanceof SYArrayNode) {
            for (Node node : values.getChildren()) {
                enumValues.add(((SimpleTypeNode)node).getLiteralValue());
            }
        }
        return enumValues;
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        StringResolvedType result = this.copy();
        if (with instanceof StringResolvedType) {
            StringResolvedType stringTypeDefinition = (StringResolvedType)with;
            result.setMaxLength(stringTypeDefinition.getMaxLength());
            result.setMinLength(stringTypeDefinition.getMinLength());
            result.setPattern(stringTypeDefinition.getPattern());
            result.setEnums(stringTypeDefinition.getEnums());
        }
        result.customFacets = result.customFacets.mergeWith(with.customFacets());
        return this.mergeFacets(result, with);
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)raml10Grammar.patternField()).add((Rule)raml10Grammar.minLengthField()).add((Rule)raml10Grammar.maxLengthField()).add((Rule)raml10Grammar.enumField()).addAll(this.customFacets.getRules());
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
    }

    @Override
    public void validateState() {
        super.validateState();
        ErrorNode errorNode = this.validateFacets();
        if (errorNode != null) {
            this.getTypeDeclarationNode().replaceWith((Node)errorNode);
        }
    }

    private ErrorNode validateFacets() {
        int maximumLength;
        int minimumLength = this.minLength != null ? this.minLength : 0;
        int n = maximumLength = this.maxLength != null ? this.maxLength : Integer.MAX_VALUE;
        if (maximumLength < minimumLength) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "maxLength must be greater than or equal to minLength");
        }
        for (String thisEnum : this.enums) {
            if (thisEnum.length() >= minimumLength && thisEnum.length() <= maximumLength) continue;
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "enum values must have between " + minimumLength + " and " + maximumLength + " characters");
        }
        return null;
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitString(this);
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.STRING.getType();
    }

    private void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    private void setMinLength(Integer minLength) {
        if (minLength != null) {
            this.minLength = minLength;
        }
    }

    private void setMaxLength(Integer maxLength) {
        if (maxLength != null) {
            this.maxLength = maxLength;
        }
    }

    public List<String> getEnums() {
        return this.enums;
    }

    public void setEnums(List<String> enums) {
        if (enums != null && !enums.isEmpty()) {
            this.enums = enums;
        }
    }

    @Nullable
    public Integer getMinLength() {
        return this.minLength;
    }

    @Nullable
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    public String getPattern() {
        return this.pattern;
    }
}

