/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.StringNode;

public class JSonDumper {
    public static String dump(Node node) {
        StringBuilder builder = new StringBuilder();
        List<String> children = JSonDumper.dumpChildren(node.getChildren());
        builder.append("{").append(StringUtils.join(children, (String)",\n")).append("}");
        return builder.toString();
    }

    private static List<String> dumpChildren(List<Node> children) {
        ArrayList valueChildren = Lists.newArrayList();
        for (Node child : children) {
            valueChildren.add(JSonDumper.dumpNode(child));
        }
        return valueChildren;
    }

    private static String dumpNode(Node child) {
        if (child instanceof KeyValueNode) {
            KeyValueNode keyValueNode = (KeyValueNode)child;
            return JSonDumper.dumpNode(keyValueNode.getKey()) + " : " + JSonDumper.dumpNode(keyValueNode.getValue());
        }
        if (child instanceof ObjectNode) {
            return JSonDumper.dump(child);
        }
        if (child instanceof StringNode) {
            return "\"" + ((StringNode)child).getValue() + "\"";
        }
        return child.toString();
    }
}

