/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.nodes.BaseResourceTypeRefNode;
import org.raml.v2.internal.impl.commons.nodes.BaseTraitRefNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ParametrizedReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceTypeNode;
import org.raml.v2.internal.impl.commons.nodes.StringTemplateNode;
import org.raml.v2.internal.impl.commons.nodes.TraitNode;
import org.raml.v2.internal.impl.commons.phase.ReferenceResolverTransformer;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsMerger;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.ExecutionContext;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNode;
import org.raml.yagi.framework.nodes.ReferenceNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.nodes.snakeyaml.SYBaseRamlNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYNullNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYObjectNode;
import org.raml.yagi.framework.phase.GrammarPhase;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.phase.TransformationPhase;
import org.raml.yagi.framework.phase.Transformer;
import org.raml.yagi.framework.util.NodeSelector;
import org.raml.yagi.framework.util.NodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypesTraitsTransformer
implements Transformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<ResourceNode> mergedResources = new HashSet<ResourceNode>();
    private BaseRamlGrammar ramlGrammar;

    public ResourceTypesTraitsTransformer(BaseRamlGrammar ramlGrammar) {
        this.ramlGrammar = ramlGrammar;
    }

    public boolean matches(Node node) {
        return (node instanceof BaseTraitRefNode || node instanceof BaseResourceTypeRefNode) && node.findAncestorWith(ResourceNode.class) != null;
    }

    public Node transform(Node node) {
        ResourceNode resourceNode = (ResourceNode)node.findAncestorWith(ResourceNode.class);
        if (this.mergedResources.contains((Object)resourceNode)) {
            return node;
        }
        this.checkTraits((KeyValueNode)resourceNode, resourceNode);
        ReferenceNode resourceTypeReference = this.findResourceTypeReference((KeyValueNode)resourceNode);
        if (resourceTypeReference != null) {
            this.applyResourceType((KeyValueNode)resourceNode, resourceTypeReference, resourceNode);
        }
        this.mergedResources.add(resourceNode);
        return node;
    }

    private void checkTraits(KeyValueNode resourceNode, ResourceNode baseResourceNode) {
        List<MethodNode> methodNodes = this.findMethodNodes(resourceNode);
        List<ReferenceNode> resourceTraitRefs = this.findTraitReferences(resourceNode);
        for (MethodNode methodNode : methodNodes) {
            List<ReferenceNode> traitRefs = this.findTraitReferences((KeyValueNode)methodNode);
            traitRefs.addAll(resourceTraitRefs);
            for (ReferenceNode traitRef : traitRefs) {
                String traitLevel = resourceTraitRefs.contains(traitRef) ? "resource" : "method";
                this.logger.debug("applying {} level trait '{}' to '{}.{}'", new Object[]{traitLevel, traitRef.getRefName(), resourceNode.getKey(), methodNode.getName()});
                this.applyTrait(methodNode, traitRef, baseResourceNode);
            }
        }
    }

    private void applyResourceType(KeyValueNode targetNode, ReferenceNode resourceTypeReference, ResourceNode baseResourceNode) {
        ResourceTypeNode refNode = (ResourceTypeNode)resourceTypeReference.getRefNode();
        if (refNode.getValue() instanceof NullNode) {
            return;
        }
        ResourceTypeNode templateNode = refNode.copy();
        templateNode.setParent(refNode.getParent());
        Map<String, Node> parameters = this.getBuiltinResourceTypeParameters(baseResourceNode);
        if (resourceTypeReference instanceof ParametrizedReferenceNode) {
            parameters.putAll(((ParametrizedReferenceNode)resourceTypeReference).getParameters());
        }
        this.resolveParameters((Node)templateNode, parameters, NodeUtils.getContextNode((Node)baseResourceNode));
        GrammarPhase grammarPhase = new GrammarPhase((Rule)this.ramlGrammar.resourceTypeParamsResolved());
        TransformationPhase referenceResolution = new TransformationPhase(new Transformer[]{new ReferenceResolverTransformer()});
        boolean success = this.applyPhases((KeyValueNode)templateNode, new Phase[]{grammarPhase, referenceResolution});
        if (success) {
            this.checkTraits((KeyValueNode)templateNode, baseResourceNode);
            ReferenceNode parentTypeReference = this.findResourceTypeReference((KeyValueNode)templateNode);
            if (parentTypeReference != null) {
                this.applyResourceType((KeyValueNode)templateNode, parentTypeReference, baseResourceNode);
            }
        }
        ResourceTypesTraitsMerger.merge(targetNode.getValue(), templateNode.getValue());
    }

    private boolean applyPhases(KeyValueNode templateNode, Phase ... phases) {
        List errorNodes = templateNode.findDescendantsWith(ErrorNode.class);
        if (errorNodes.isEmpty()) {
            for (Phase phase : phases) {
                phase.apply(templateNode.getValue());
                errorNodes = templateNode.findDescendantsWith(ErrorNode.class);
                if (errorNodes.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, Node> getBuiltinResourceTypeParameters(ResourceNode resourceNode) {
        HashMap<String, Node> parameters = new HashMap<String, Node>();
        parameters.put("resourcePathName", (Node)new StringNodeImpl(resourceNode.getResourcePathName()));
        parameters.put("resourcePath", (Node)new StringNodeImpl(resourceNode.getResourcePath()));
        return parameters;
    }

    private Map<String, Node> getBuiltinTraitParameters(MethodNode methodNode, ResourceNode resourceNode) {
        Map<String, Node> parameters = this.getBuiltinResourceTypeParameters(resourceNode);
        parameters.put("methodName", (Node)new StringNodeImpl(methodNode.getName()));
        return parameters;
    }

    private void applyTrait(MethodNode methodNode, ReferenceNode traitReference, ResourceNode baseResourceNode) {
        TraitNode refNode = (TraitNode)traitReference.getRefNode();
        if (refNode.getValue() instanceof NullNode) {
            return;
        }
        TraitNode copy = refNode.copy();
        copy.setParent(refNode.getParent());
        this.replaceNullValueWithObject((KeyValueNode)copy);
        Map<String, Node> parameters = this.getBuiltinTraitParameters(methodNode, baseResourceNode);
        if (traitReference instanceof ParametrizedReferenceNode) {
            parameters.putAll(((ParametrizedReferenceNode)traitReference).getParameters());
        }
        this.resolveParameters((Node)copy, parameters, NodeUtils.getContextNode((Node)methodNode));
        GrammarPhase validatePhase = new GrammarPhase(this.ramlGrammar.traitParamsResolved());
        TransformationPhase referenceResolution = new TransformationPhase(new Transformer[]{new ReferenceResolverTransformer()});
        this.applyPhases((KeyValueNode)copy, new Phase[]{validatePhase, referenceResolution});
        this.replaceNullValueWithObject((KeyValueNode)methodNode);
        ResourceTypesTraitsMerger.merge(methodNode.getValue(), copy.getValue());
    }

    private void resolveParameters(Node parameterizedNode, Map<String, Node> parameters, Node referenceContext) {
        ExecutionContext context = new ExecutionContext(parameters, referenceContext);
        List templateNodes = parameterizedNode.findDescendantsWith(StringTemplateNode.class);
        for (StringTemplateNode templateNode : templateNodes) {
            Node resolvedNode = templateNode.execute(context);
            templateNode.replaceTree(resolvedNode);
        }
    }

    private void replaceNullValueWithObject(KeyValueNode keyValueNode) {
        Node valueNode = keyValueNode.getValue();
        if (valueNode instanceof SYNullNode) {
            SYBaseRamlNode ramlNode = (SYBaseRamlNode)valueNode;
            valueNode = new SYObjectNode(ramlNode);
            keyValueNode.setValue(valueNode);
        }
    }

    private List<ReferenceNode> findTraitReferences(KeyValueNode keyValueNode) {
        ArrayList<ReferenceNode> result = new ArrayList<ReferenceNode>();
        Node isNode = NodeSelector.selectFrom((String)"is", (Node)keyValueNode.getValue());
        if (isNode != null) {
            List children = isNode.getChildren();
            for (Node child : children) {
                result.add((ReferenceNode)child);
            }
        }
        return result;
    }

    private ReferenceNode findResourceTypeReference(KeyValueNode resourceNode) {
        return (ReferenceNode)NodeSelector.selectFrom((String)"type", (Node)resourceNode.getValue());
    }

    private List<MethodNode> findMethodNodes(KeyValueNode resourceNode) {
        ArrayList<MethodNode> methodNodes = new ArrayList<MethodNode>();
        for (Node node : resourceNode.getValue().getChildren()) {
            if (!(node instanceof MethodNode)) continue;
            methodNodes.add((MethodNode)node);
        }
        return methodNodes;
    }
}

