/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;

public class UnionResolvedType
implements ResolvedType {
    private List<ResolvedType> of;
    private TypeDeclarationNode typeNode;

    public UnionResolvedType(TypeDeclarationNode typeNode, List<ResolvedType> of) {
        this.typeNode = typeNode;
        this.of = of;
    }

    public List<ResolvedType> of() {
        return this.of;
    }

    protected UnionResolvedType copy() {
        return new UnionResolvedType(this.typeNode, new ArrayList<ResolvedType>(this.of));
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        ArrayList<ResolvedType> result = new ArrayList<ResolvedType>();
        List<ResolvedType> of = this.of();
        for (ResolvedType resolvedType : of) {
            result.add(resolvedType.overwriteFacets(from));
        }
        return new UnionResolvedType(from, result);
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        if (with instanceof UnionResolvedType) {
            List<ResolvedType> of = ((UnionResolvedType)with).of();
            return this.mergeWith(of);
        }
        return this.mergeWith(Collections.singletonList(with));
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitUnion(this);
    }

    @Override
    @Nullable
    public String getTypeName() {
        return this.typeNode != null ? this.typeNode.getTypeName() : null;
    }

    @Override
    public TypeDeclarationNode getTypeDeclarationNode() {
        return this.typeNode;
    }

    protected ResolvedType mergeWith(List<ResolvedType> of) {
        ArrayList<ResolvedType> combination = new ArrayList<ResolvedType>();
        for (ResolvedType localDefinition : this.of()) {
            for (ResolvedType resolvedType : of) {
                combination.add(localDefinition.mergeFacets(resolvedType));
            }
        }
        return new UnionResolvedType(this.typeNode, combination);
    }
}

