/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.yagi.framework.util.NodeSelector;

public class StringResolvedType
extends XmlFacetsCapableType {
    private Integer minLength;
    private Integer maxLength;
    private String pattern;
    private List<String> enums = new ArrayList<String>();

    public StringResolvedType(TypeDeclarationNode from) {
        super(from);
    }

    public StringResolvedType(TypeDeclarationNode declarationNode, XmlFacets xmlFacets, Integer minLength, Integer maxLength, String pattern, List<String> enums) {
        super(declarationNode, xmlFacets);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.pattern = pattern;
        this.enums = enums;
    }

    protected StringResolvedType copy() {
        return new StringResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets(), this.minLength, this.maxLength, this.pattern, this.enums);
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        StringResolvedType result = this.copy();
        result.setMinLength(NodeSelector.selectIntValue((String)"minLength", (Node)from));
        result.setMaxLength(NodeSelector.selectIntValue((String)"maxLength", (Node)from));
        result.setPattern(NodeSelector.selectStringValue((String)"pattern", (Node)from));
        result.setEnums(this.getEnumValues((Node)from));
        return this.overwriteFacets(result, from);
    }

    @Nonnull
    private List<String> getEnumValues(Node typeNode) {
        Node values = typeNode.get("enum");
        ArrayList<String> enumValues = new ArrayList<String>();
        if (values != null && values instanceof SYArrayNode) {
            for (Node node : values.getChildren()) {
                enumValues.add(((StringNode)node).getValue());
            }
        }
        return enumValues;
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        StringResolvedType result = this.copy();
        if (with instanceof StringResolvedType) {
            StringResolvedType stringTypeDefinition = (StringResolvedType)with;
            result.setMaxLength(stringTypeDefinition.getMaxLength());
            result.setMinLength(stringTypeDefinition.getMinLength());
            result.setPattern(stringTypeDefinition.getPattern());
            result.setEnums(stringTypeDefinition.getEnums());
        }
        return this.mergeFacets(result, with);
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitString(this);
    }

    private void setPattern(String pattern) {
        if (pattern != null) {
            this.pattern = pattern;
        }
    }

    private void setMinLength(Integer minLength) {
        if (minLength != null) {
            this.minLength = minLength;
        }
    }

    private void setMaxLength(Integer maxLength) {
        if (maxLength != null) {
            this.maxLength = maxLength;
        }
    }

    public List<String> getEnums() {
        return this.enums;
    }

    public void setEnums(List<String> enums) {
        if (enums != null && !enums.isEmpty()) {
            this.enums = enums;
        }
    }

    @Nullable
    public Integer getMinLength() {
        return this.minLength;
    }

    @Nullable
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    public String getPattern() {
        return this.pattern;
    }
}

