/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.yagi.framework.util.NodeSelector;

public class NumberResolvedType
extends XmlFacetsCapableType {
    private Number minimum;
    private Number maximum;
    private Number multiple;
    private String format;
    private List<Number> enums = new ArrayList<Number>();

    public NumberResolvedType(TypeDeclarationNode from) {
        super(from);
    }

    public NumberResolvedType(TypeDeclarationNode declarationNode, XmlFacets xmlFacets, Number minimum, Number maximum, Number multiple, String format) {
        super(declarationNode, xmlFacets);
        this.minimum = minimum;
        this.maximum = maximum;
        this.multiple = multiple;
        this.format = format;
    }

    public NumberResolvedType copy() {
        return new NumberResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets().copy(), this.minimum, this.maximum, this.multiple, this.format);
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        NumberResolvedType result = this.copy();
        result.setMinimum(NodeSelector.selectIntValue((String)"minimum", (Node)from));
        result.setMaximum(NodeSelector.selectIntValue((String)"maximum", (Node)from));
        result.setMultiple(NodeSelector.selectIntValue((String)"multipleOf", (Node)from));
        result.setFormat(NodeSelector.selectStringValue((String)"format", (Node)from));
        result.setEnums(this.getEnumValues((Node)from));
        return this.overwriteFacets(result, from);
    }

    @Nonnull
    private List<Number> getEnumValues(Node typeNode) {
        Node values = typeNode.get("enum");
        ArrayList<Number> enumValues = new ArrayList<Number>();
        if (values != null && values instanceof SYArrayNode) {
            for (Node node : values.getChildren()) {
                enumValues.add((Number)((SimpleTypeNode)node).getValue());
            }
        }
        return enumValues;
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        NumberResolvedType result = this.copy();
        if (with instanceof NumberResolvedType) {
            NumberResolvedType numberTypeDefinition = (NumberResolvedType)with;
            result.setMinimum(numberTypeDefinition.getMinimum());
            result.setMaximum(numberTypeDefinition.getMaximum());
            result.setMultiple(numberTypeDefinition.getMultiple());
            result.setFormat(numberTypeDefinition.getFormat());
            result.setEnums(numberTypeDefinition.getEnums());
        }
        return this.mergeFacets(result, with);
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitNumber(this);
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public List<Number> getEnums() {
        return this.enums;
    }

    public void setEnums(List<Number> enums) {
        if (enums != null && !enums.isEmpty()) {
            this.enums = enums;
        }
    }

    private void setMinimum(Number minimum) {
        if (minimum != null) {
            this.minimum = minimum;
        }
    }

    public Number getMaximum() {
        return this.maximum;
    }

    private void setMaximum(Number maximum) {
        if (maximum != null) {
            this.maximum = maximum;
        }
    }

    public Number getMultiple() {
        return this.multiple;
    }

    private void setMultiple(Number multiple) {
        if (multiple != null) {
            this.multiple = multiple;
        }
    }

    public String getFormat() {
        return this.format;
    }

    private void setFormat(String format) {
        if (format != null) {
            this.format = format;
        }
    }
}

