/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.List;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class FileResolvedType
extends XmlFacetsCapableType {
    private Number minLength;
    private Number maxLength;
    private List<String> fileTypes;

    public FileResolvedType(TypeDeclarationNode from) {
        super(from);
    }

    public FileResolvedType(TypeDeclarationNode declarationNode, XmlFacets xmlFacets, Number minLength, Number maxLength, List<String> fileTypes) {
        super(declarationNode, xmlFacets);
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.fileTypes = fileTypes;
    }

    protected FileResolvedType copy() {
        return new FileResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets().copy(), this.minLength, this.maxLength, this.fileTypes);
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        FileResolvedType result = this.copy();
        result.setMinLength(NodeSelector.selectIntValue((String)"minLength", (Node)from));
        result.setMaxLength(NodeSelector.selectIntValue((String)"maxLength", (Node)from));
        result.setFileTypes(NodeSelector.selectStringCollection((String)"fileTypes", (Node)from));
        return this.overwriteFacets(result, from);
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        FileResolvedType result = this.copy();
        if (with instanceof FileResolvedType) {
            FileResolvedType fileTypeDefinition = (FileResolvedType)with;
            result.setMinLength(fileTypeDefinition.getMinLength());
            result.setMaxLength(fileTypeDefinition.getMaxLength());
            result.setFileTypes(fileTypeDefinition.getFileTypes());
        }
        return this.mergeFacets(result, with);
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitFile(this);
    }

    public Number getMinLength() {
        return this.minLength;
    }

    public List<String> getFileTypes() {
        return this.fileTypes;
    }

    public void setFileTypes(List<String> fileTypes) {
        if (fileTypes != null && !fileTypes.isEmpty()) {
            this.fileTypes = fileTypes;
        }
    }

    public void setMinLength(Number minLength) {
        if (minLength != null) {
            this.minLength = minLength;
        }
    }

    public Number getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Number maxLength) {
        if (maxLength != null) {
            this.maxLength = maxLength;
        }
    }
}

