/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.grammar;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.ExtendsNode;
import org.raml.v2.internal.impl.commons.nodes.ExternalSchemaTypeExpressionNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.rule.NodeReferenceFactory;
import org.raml.v2.internal.impl.commons.rule.SchemaDeclarationRule;
import org.raml.v2.internal.impl.v10.grammar.AuthorizationUriRequiredField;
import org.raml.v2.internal.impl.v10.nodes.DisplayNameDefaultValue;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryNode;
import org.raml.v2.internal.impl.v10.nodes.NativeTypeExpressionNode;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.nodes.factory.DefaultMimeTypeDeclarationFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.InlineTypeDeclarationFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.OverlayableSimpleTypeFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.RamlScalarValueFactory;
import org.raml.v2.internal.impl.v10.nodes.factory.TypeExpressionReferenceFactory;
import org.raml.v2.internal.impl.v10.rules.TypeDefaultValue;
import org.raml.v2.internal.impl.v10.rules.TypeExpressionReferenceRule;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.yagi.framework.grammar.RuleFactory;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.ArrayWrapperFactory;
import org.raml.yagi.framework.grammar.rule.ConditionalRule;
import org.raml.yagi.framework.grammar.rule.DefaultValue;
import org.raml.yagi.framework.grammar.rule.KeyValueRule;
import org.raml.yagi.framework.grammar.rule.NodeFactory;
import org.raml.yagi.framework.grammar.rule.ObjectRule;
import org.raml.yagi.framework.grammar.rule.RegexValueRule;
import org.raml.yagi.framework.grammar.rule.RequiredField;
import org.raml.yagi.framework.grammar.rule.ResourceRefRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.grammar.rule.StringValueRule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NullNodeImpl;

public class Raml10Grammar
extends BaseRamlGrammar {
    public static final String ANNOTATION_TYPES_KEY_NAME = "annotationTypes";
    public static final String DEFAULT_TYPE_RULE = "defaultTypeRule";
    public static final String PROPERTY_TYPE_RULE = "propertyTypeRule";

    @Override
    public ObjectRule untitledRaml() {
        return super.untitledRaml().with(this.annotationTypesField()).with(this.annotationField()).with(this.typesField()).with(this.usesField());
    }

    @Override
    protected ObjectRule resourceValue() {
        return (ObjectRule)this.named("resourceValue", (RuleFactory)new RuleFactory<ObjectRule>(){

            public ObjectRule create() {
                return Raml10Grammar.this.baseResourceValue().with(Raml10Grammar.this.field((Rule)Raml10Grammar.this.anyMethod(), (Rule)Raml10Grammar.this.methodValue()).then(MethodNode.class)).with(Raml10Grammar.this.field((Rule)Raml10Grammar.this.resourceKey(), (Rule)Raml10Grammar.this.resourceValue()).then(ResourceNode.class)).with(Raml10Grammar.this.annotationField());
            }
        });
    }

    @Override
    protected ObjectRule methodValue() {
        return super.methodValue().with(this.field((Rule)this.queryStringKey(), this.type())).with(this.annotationField());
    }

    @Override
    protected ObjectRule securitySchemePart() {
        return super.securitySchemePart().with(this.annotationField());
    }

    @Override
    protected ObjectRule securitySchemeSettings() {
        return super.securitySchemeSettings().with(this.field((Rule)this.string("signatures"), (Rule)this.array(this.scalarType()))).with(this.field((Rule)this.string("authorizationUri"), this.ramlScalarValue()).requiredWhen((RequiredField)new AuthorizationUriRequiredField()));
    }

    @Override
    protected ObjectRule response() {
        return super.response().with(this.annotationField());
    }

    protected KeyValueRule typesField() {
        return this.field((Rule)this.typesKey(), this.types());
    }

    protected StringValueRule typesKey() {
        return this.string("types").description("Declarations of (data) types for use within this API.");
    }

    protected KeyValueRule annotationField() {
        return this.field(this.annotationKey().then((NodeFactory)new NodeReferenceFactory(AnnotationReferenceNode.class)), (Rule)this.any()).then(AnnotationNode.class);
    }

    protected RegexValueRule annotationKey() {
        return this.regex("\\((.+)\\)").label("(Annotation)").suggest("(<cursor>)").description("Annotations to be applied to this API. Annotations are any property whose key begins with \"(\" and ends with \")\" and whose name (the part between the beginning and ending parentheses) is a declared annotation name..");
    }

    public KeyValueRule usesField() {
        return this.field((Rule)this.usesKey(), (Rule)this.objectType().with(this.field(this.scalarType(), this.libraryRef()).then(LibraryNode.class)));
    }

    public ObjectRule extension() {
        return this.untitledRaml().with(this.requiredField((Rule)this.extendsKey(), this.scalarType()).then(ExtendsNode.class)).with(this.usageField()).with(this.optionalTitleField());
    }

    protected StringValueRule extendsKey() {
        return this.string("extends").description("The path to the base RAML document to be extended.");
    }

    protected KeyValueRule optionalTitleField() {
        return this.field((Rule)this.titleKey(), this.titleValue());
    }

    public Rule libraryRef() {
        return new ResourceRefRule().then(LibraryLinkNode.class);
    }

    public ObjectRule libraryValue() {
        return (ObjectRule)this.named("library", (RuleFactory)new RuleFactory<ObjectRule>(){

            public ObjectRule create() {
                return Raml10Grammar.this.objectType().with(Raml10Grammar.this.typesField()).with(Raml10Grammar.this.schemasField()).with(Raml10Grammar.this.resourceTypesField()).with(Raml10Grammar.this.traitsField()).with(Raml10Grammar.this.securitySchemesField()).with(Raml10Grammar.this.annotationTypesField()).with(Raml10Grammar.this.annotationField()).with(Raml10Grammar.this.usesField()).with(Raml10Grammar.this.usageField());
            }
        });
    }

    protected KeyValueRule annotationTypesField() {
        return this.field((Rule)this.annotationTypesKey(), this.annotationTypes());
    }

    protected StringValueRule annotationTypesKey() {
        return this.string(ANNOTATION_TYPES_KEY_NAME).description("Declarations of annotation types for use by annotations.");
    }

    protected Rule annotationTypes() {
        return this.objectType().with(this.field(this.scalarType(), this.annotationType()).then(AnnotationTypeNode.class));
    }

    private Rule annotationType() {
        return this.anyOf(new Rule[]{this.inlineType(), this.explicitType().with(this.allowedTargetsField())});
    }

    private KeyValueRule allowedTargetsField() {
        return this.field((Rule)this.string("allowedTargets"), this.anyOf(new Rule[]{this.scalarType(), this.array(this.scalarType())}).then((NodeFactory)new ArrayWrapperFactory()));
    }

    protected Rule types() {
        return this.objectType().with(this.field(this.scalarType(), this.type()).then(TypeDeclarationField.class));
    }

    @Override
    protected Rule parameter() {
        return this.anyOf(new Rule[]{this.inlineType(), this.propertyType()});
    }

    public Rule type() {
        return this.anyOf(new Rule[]{this.inlineType(), this.explicitType()});
    }

    private AnyOfRule typeRef() {
        return this.anyOf(new Rule[]{this.inlineType(), this.explicitType()});
    }

    protected Rule inlineType() {
        return this.typeExpressionReference().then((NodeFactory)new InlineTypeDeclarationFactory());
    }

    public ObjectRule explicitType() {
        return this.baseType(TypeId.STRING, DEFAULT_TYPE_RULE, new KeyValueRule[0]);
    }

    private ObjectRule baseType(final TypeId defaultType, String ruleName, final KeyValueRule ... additionalRules) {
        return (ObjectRule)this.named(ruleName, (RuleFactory)new RuleFactory<ObjectRule>(){

            public ObjectRule create() {
                return Raml10Grammar.this.objectType().with(Raml10Grammar.this.typeField(defaultType)).with(Raml10Grammar.this.xmlFacetField()).with(Raml10Grammar.this.displayNameField()).with(Raml10Grammar.this.descriptionField()).with(Raml10Grammar.this.usageField()).with(Raml10Grammar.this.annotationField()).with(Raml10Grammar.this.defaultField()).with(Raml10Grammar.this.requiredField()).with(Raml10Grammar.this.facetsField()).with(Raml10Grammar.this.exampleField()).with(Raml10Grammar.this.examplesField()).with(Raml10Grammar.this.when(Arrays.asList("type", "schema"), new ConditionalRule[]{Raml10Grammar.this.is((Rule)Raml10Grammar.this.stringTypeLiteral()).add(Raml10Grammar.this.patternField()).add(Raml10Grammar.this.minLengthField()).add(Raml10Grammar.this.maxLengthField()).add(Raml10Grammar.this.enumField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.dateTimeTypeLiteral()).add(Raml10Grammar.this.formatField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.arrayTypeLiteral()).add(Raml10Grammar.this.uniqueItemsField()).add(Raml10Grammar.this.itemsField()).add(Raml10Grammar.this.minItemsField()).add(Raml10Grammar.this.maxItemsField()), Raml10Grammar.this.is(Raml10Grammar.this.numericTypeLiteral()).add(Raml10Grammar.this.minimumField()).add(Raml10Grammar.this.maximumField()).add(Raml10Grammar.this.numberFormat()).add(Raml10Grammar.this.enumField()).add(Raml10Grammar.this.multipleOfField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.fileTypeLiteral()).add(Raml10Grammar.this.fileTypesField()).add(Raml10Grammar.this.minLengthField()).add(Raml10Grammar.this.maxLengthField()), Raml10Grammar.this.is(Raml10Grammar.this.objectTypeLiteral()).add(Raml10Grammar.this.propertiesField()).add(Raml10Grammar.this.minPropertiesField()).add(Raml10Grammar.this.maxPropertiesField()).add(Raml10Grammar.this.additionalPropertiesField()).add(Raml10Grammar.this.discriminatorField()).add(Raml10Grammar.this.discriminatorValueField()), Raml10Grammar.this.is((Rule)Raml10Grammar.this.not(Raml10Grammar.this.builtinTypes())).add(Raml10Grammar.this.patternField()).add(Raml10Grammar.this.minLengthField()).add(Raml10Grammar.this.maxLengthField()).add(Raml10Grammar.this.enumField()).add(Raml10Grammar.this.formatField()).add(Raml10Grammar.this.uniqueItemsField()).add(Raml10Grammar.this.itemsField()).add(Raml10Grammar.this.minItemsField()).add(Raml10Grammar.this.maxItemsField()).add(Raml10Grammar.this.minimumField()).add(Raml10Grammar.this.maximumField()).add(Raml10Grammar.this.numberFormat()).add(Raml10Grammar.this.multipleOfField()).add(Raml10Grammar.this.fileTypesField()).add(Raml10Grammar.this.propertiesField()).add(Raml10Grammar.this.minPropertiesField()).add(Raml10Grammar.this.maxPropertiesField()).add(Raml10Grammar.this.additionalPropertiesField()).add(Raml10Grammar.this.discriminatorField()).add(Raml10Grammar.this.discriminatorValueField()).add(Raml10Grammar.this.field((Rule)Raml10Grammar.this.facetRegex(), (Rule)Raml10Grammar.this.any()))}).defaultValue((DefaultValue)new TypeDefaultValue(defaultType))).withAll(additionalRules).then(TypeDeclarationNode.class);
            }
        });
    }

    protected Rule builtinTypes() {
        TypeId[] values = TypeId.values();
        ArrayList<StringValueRule> typeNames = new ArrayList<StringValueRule>();
        for (TypeId value : values) {
            typeNames.add(this.string(value.getType()));
        }
        return this.anyOf(typeNames);
    }

    protected KeyValueRule discriminatorValueField() {
        return this.field((Rule)this.string("discriminatorValue"), this.scalarType()).description("Identifies the declaring type. Requires including a discriminator facet in the type declaration. A valid value is an actual value that might identify the type of an individual object and is unique in the hierarchy of the type. Inline type declarations are not supported.");
    }

    protected KeyValueRule discriminatorField() {
        return this.field((Rule)this.string("discriminator"), this.scalarType()).description("Determines the concrete type of an individual object at runtime when, for example, payloads contain ambiguous types due to unions or inheritance. The value must match the name of one of the declared properties of a type. Unsupported practices are inline type declarations and using discriminator with non-scalar properties.");
    }

    protected KeyValueRule additionalPropertiesField() {
        return this.field((Rule)this.string("additionalProperties"), (Rule)this.booleanType()).description("A Boolean that indicates if an object instance has additional properties.");
    }

    protected KeyValueRule maxPropertiesField() {
        return this.field((Rule)this.string("maxProperties"), (Rule)this.integerType()).description("The maximum number of properties allowed for instances of this type.");
    }

    protected KeyValueRule minPropertiesField() {
        return this.field((Rule)this.string("minProperties"), (Rule)this.integerType()).description("The minimum number of properties allowed for instances of this type.");
    }

    protected KeyValueRule propertiesField() {
        return this.field((Rule)this.string("properties"), (Rule)this.properties()).description("The properties that instances of this type can or must have.");
    }

    protected KeyValueRule fileTypesField() {
        return this.field((Rule)this.string("fileTypes"), (Rule)this.any()).description("A list of valid content-type strings for the file. The file type */* MUST be a valid value.");
    }

    protected KeyValueRule multipleOfField() {
        return this.field((Rule)this.string("multipleOf"), (Rule)this.integerType()).description("A numeric instance is valid against \"multipleOf\" if the result of dividing the instance by this keyword's value is an integer.");
    }

    protected KeyValueRule numberFormat() {
        return this.field((Rule)this.string("format"), (Rule)this.anyOf(new Rule[]{this.string("int32"), this.string("int64"), this.string("int"), this.string("long"), this.string("float"), this.string("float"), this.string("int16"), this.string("int8")})).description("The format of the value. The value MUST be one of the following: int32, int64, int, long, float, double, int16, int8");
    }

    protected KeyValueRule maximumField() {
        return this.field((Rule)this.string("maximum"), (Rule)this.integerType()).description("The maximum value of the parameter. Applicable only to parameters of type number or integer.");
    }

    protected KeyValueRule minimumField() {
        return this.field((Rule)this.string("minimum"), (Rule)this.integerType()).description("The minimum value of the parameter. Applicable only to parameters of type number or integer.");
    }

    protected KeyValueRule maxItemsField() {
        return this.field((Rule)this.string("maxItems"), (Rule)this.integerType()).description("Maximum amount of items in array. Value MUST be equal to or greater than 0.");
    }

    protected KeyValueRule minItemsField() {
        return this.field((Rule)this.string("minItems"), (Rule)this.integerType()).description("Minimum amount of items in array. Value MUST be equal to or greater than 0.");
    }

    protected KeyValueRule itemsField() {
        return this.field((Rule)this.string("items"), (Rule)this.typeRef()).description("Indicates the type all items in the array are inherited from. Can be a reference to an existing type or an inline type declaration.");
    }

    protected KeyValueRule uniqueItemsField() {
        return this.field((Rule)this.string("uniqueItems"), (Rule)this.booleanType()).description("Boolean value that indicates if items in the array MUST be unique.");
    }

    protected KeyValueRule formatField() {
        return this.field((Rule)this.string("format"), (Rule)this.anyOf(new Rule[]{this.string("rfc3339"), this.string("rfc2616")}));
    }

    protected KeyValueRule enumField() {
        return this.field((Rule)this.string("enum"), (Rule)this.array(this.scalarType())).description("Enumeration of possible values for this built-in scalar type. The value is an array containing representations of possible values, or a single value if there is only one possible value.");
    }

    protected KeyValueRule maxLengthField() {
        return this.field((Rule)this.string("maxLength"), (Rule)this.integerType()).description("Maximum length of the string. Value MUST be equal to or greater than 0.");
    }

    protected KeyValueRule minLengthField() {
        return this.field((Rule)this.string("minLength"), (Rule)this.integerType()).description("Minimum length of the string. Value MUST be equal to or greater than 0.");
    }

    protected KeyValueRule patternField() {
        return this.field((Rule)this.string("pattern"), this.scalarType()).description("Regular expression that this string should match.");
    }

    protected KeyValueRule examplesField() {
        return this.field((Rule)this.exclusiveWith("examples", "example"), (Rule)this.examplesValue()).description("Examples of instances of this type. This can be used, for example, by documentation generators to generate sample values for an object of this type. The \"examples\" facet MUST not be available when the \"example\" facet is already defined. See section Examples for more information.");
    }

    protected KeyValueRule exampleField() {
        return this.field((Rule)this.exclusiveWith("example", "examples"), this.exampleValue()).then(ExampleDeclarationNode.class).description("An example of an instance of this type that can be used, for example, by documentation generators to generate sample values for an object of this type. The \"example\" facet MUST not be available when the \"examples\" facet is already defined. See section Examples for more information.");
    }

    protected KeyValueRule facetsField() {
        return this.field((Rule)this.string("facets"), (Rule)this.objectType().with(this.field((Rule)this.facetRegex(), (Rule)this.typeRef()))).description("A map of additional, user-defined restrictions that will be inherited and applied by any extending subtype. See section User-defined Facets for more information.");
    }

    private RegexValueRule facetRegex() {
        return this.regex("[^\\(].*");
    }

    protected ObjectRule examplesValue() {
        return this.objectType().with(this.field(this.scalarType(), this.exampleValue()).then(ExampleDeclarationNode.class));
    }

    private KeyValueRule typeField(TypeId defaultType) {
        return this.field((Rule)this.anyOf(new Rule[]{this.typeKey(), this.schemaKey()}), (Rule)this.anyOf(new Rule[]{this.typeExpressionReference(), this.array((Rule)this.typeExpressionReference())})).defaultValue((DefaultValue)new TypeDefaultValue(defaultType)).description("A base type which the current type extends or just wraps. The value of a type node MUST be either a) the name of a user-defined type or b) the name of a built-in RAML data type (object, array, or one of the scalar types) or c) an inline type declaration.");
    }

    private KeyValueRule requiredField() {
        return this.field((Rule)this.string("required"), (Rule)this.booleanType());
    }

    private StringValueRule schemaKey() {
        return this.string("schema");
    }

    private KeyValueRule xmlFacetField() {
        return this.field((Rule)this.string("xml"), (Rule)this.objectType().with(this.attributeField()).with(this.wrappedField()).with(this.xmlNameField()).with(this.namespaceField()).with(this.prefixField()));
    }

    private KeyValueRule xmlNameField() {
        return this.field((Rule)this.string("name"), (Rule)this.stringType()).description("Overrides the name of the XML element or XML attribute.");
    }

    private KeyValueRule prefixField() {
        return this.field((Rule)this.string("prefix"), (Rule)this.stringType()).description("Configures the prefix used during serialization to XML.");
    }

    private KeyValueRule namespaceField() {
        return this.field((Rule)this.string("namespace"), (Rule)this.stringType()).description("Configures the name of the XML namespace.");
    }

    private KeyValueRule wrappedField() {
        return this.field((Rule)this.string("wrapped"), (Rule)this.booleanType()).description("true wraps a type instance in its own XML element. Cannot be true for scalar types or true at the same moment attribute is true.");
    }

    private KeyValueRule attributeField() {
        return this.field((Rule)this.string("attribute"), (Rule)this.booleanType()).description("Serializes a type instance as an XML attribute. Can be true only for scalar types.");
    }

    private KeyValueRule defaultField() {
        return this.field((Rule)this.string("default"), (Rule)this.any());
    }

    private AnyOfRule typeExpressionReference() {
        return this.anyOf(new Rule[]{this.nullValue().then(NativeTypeExpressionNode.class), new SchemaDeclarationRule().then(ExternalSchemaTypeExpressionNode.class), new TypeExpressionReferenceRule().then(new TypeExpressionReferenceFactory())});
    }

    @Override
    protected Rule mimeType() {
        return this.anyOf(new Rule[]{this.nullValue().then((NodeFactory)new DefaultMimeTypeDeclarationFactory()), this.baseType(TypeId.ANY, "mimeType", new KeyValueRule[0])});
    }

    protected Rule exampleValue() {
        return this.anyOf(new Rule[]{this.explicitExample(), this.any()});
    }

    private ObjectRule explicitExample() {
        return this.objectType().with(this.when("value", new ConditionalRule[]{this.is((Rule)this.not((Rule)this.nullValue())).add(this.displayNameField()).add(this.descriptionField()).add(this.annotationField()).add(this.field((Rule)this.string("value"), (Rule)this.any())).add(this.field((Rule)this.string("strict"), (Rule)this.booleanType())), this.is((Rule)this.nullValue()).add(this.field(this.scalarType(), (Rule)this.any()))}).defaultValue((Node)new NullNodeImpl()));
    }

    protected StringValueRule fileTypeLiteral() {
        return this.string("file");
    }

    protected Rule numericTypeLiteral() {
        return this.anyOf(new Rule[]{this.numberTypeLiteral(), this.integerTypeLiteral()});
    }

    protected Rule numberTypeLiteral() {
        return this.string("number");
    }

    protected Rule integerTypeLiteral() {
        return this.string("integer");
    }

    protected StringValueRule stringTypeLiteral() {
        return this.string("string");
    }

    private StringValueRule dateTimeTypeLiteral() {
        return this.string("datetime");
    }

    protected AnyOfRule arrayTypeLiteral() {
        return new AnyOfRule(new Rule[]{this.regex(".+\\[\\]"), this.string("array")});
    }

    protected ObjectRule properties() {
        return this.objectType().with(this.propertyField());
    }

    private KeyValueRule propertyField() {
        return this.field(this.scalarType(), (Rule)this.anyOf(new Rule[]{this.inlineType(), this.propertyType()})).then(PropertyNode.class);
    }

    private ObjectRule propertyType() {
        return this.baseType(TypeId.STRING, PROPERTY_TYPE_RULE, this.requiredField());
    }

    protected Rule objectTypeLiteral() {
        return this.string("object");
    }

    @Override
    protected KeyValueRule mediaTypeField() {
        return this.field((Rule)this.mediaTypeKey(), (Rule)this.anyOf(new Rule[]{this.scalarType(), this.array(this.scalarType())}));
    }

    @Override
    protected Rule schemasValue() {
        return this.types();
    }

    @Override
    @Nonnull
    protected String schemasDescription() {
        return "Alias for the equivalent \"types\" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the \"types\" property, as the \"schemas\" alias for that property name may be removed in a future RAML version. The \"types\" property allows for XML and JSON schemas.";
    }

    @Override
    protected KeyValueRule displayNameField() {
        return this.field((Rule)this.displayNameKey(), this.ramlScalarValue()).defaultValue((DefaultValue)new DisplayNameDefaultValue());
    }

    @Override
    protected Rule resourceTypesValue() {
        return this.resourceTypes();
    }

    @Override
    protected Rule securitySchemesValue() {
        return this.securitySchemes();
    }

    @Override
    protected Rule descriptionValue() {
        return this.firstOf(new Rule[]{this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(true)), this.annotatedScalarType(this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(false)))});
    }

    @Override
    protected KeyValueRule docTitleField() {
        return this.requiredField((Rule)this.titleKey(), (Rule)this.firstOf(new Rule[]{this.allOf(new Rule[]{this.minLength(1), this.ramlScalarValue()}), this.annotatedScalarType((Rule)this.allOf(new Rule[]{this.minLength(1), this.scalarType()}))}));
    }

    @Override
    protected Rule titleValue() {
        return this.firstOf(new Rule[]{this.allOf(new Rule[]{this.minLength(1), this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(true))}), this.annotatedScalarType((Rule)this.allOf(new Rule[]{this.minLength(1), this.scalarType().then((NodeFactory)new OverlayableSimpleTypeFactory(false))}))});
    }

    @Override
    public Rule ramlScalarValue() {
        return this.firstOf(new Rule[]{this.scalarType().then((NodeFactory)new RamlScalarValueFactory()), this.annotatedScalarType()});
    }

    protected Rule annotatedScalarType() {
        return this.annotatedScalarType(this.scalarType());
    }

    protected Rule annotatedScalarType(Rule customScalarRule) {
        return this.objectType().with(this.field((Rule)this.string("value"), customScalarRule)).with(this.annotationField());
    }
}

