/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.nodes.BaseResourceTypeRefNode;
import org.raml.v2.internal.impl.commons.nodes.BaseTraitRefNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceTypeNode;
import org.raml.v2.internal.impl.commons.nodes.StringTemplateNode;
import org.raml.v2.internal.impl.commons.nodes.TraitNode;
import org.raml.v2.internal.impl.commons.phase.ReferenceResolverTransformer;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsMerger;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.ExecutionContext;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ParametrizedReferenceNode;
import org.raml.yagi.framework.nodes.ReferenceNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYBaseRamlNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYNullNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYObjectNode;
import org.raml.yagi.framework.phase.GrammarPhase;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.phase.TransformationPhase;
import org.raml.yagi.framework.phase.Transformer;
import org.raml.yagi.framework.util.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypesTraitsTransformer
implements Transformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<ResourceNode> mergedResources = new HashSet<ResourceNode>();
    private BaseRamlGrammar ramlGrammar;

    public ResourceTypesTraitsTransformer(BaseRamlGrammar ramlGrammar) {
        this.ramlGrammar = ramlGrammar;
    }

    public boolean matches(Node node) {
        return node instanceof BaseTraitRefNode || node instanceof BaseResourceTypeRefNode;
    }

    public Node transform(Node node) {
        ResourceNode resourceNode = (ResourceNode)node.findAncestorWith(ResourceNode.class);
        if (this.mergedResources.contains((Object)resourceNode)) {
            return node;
        }
        this.checkTraits((KeyValueNode)resourceNode, resourceNode);
        ReferenceNode resourceTypeReference = this.findResourceTypeReference((KeyValueNode)resourceNode);
        if (resourceTypeReference != null) {
            this.applyResourceType((KeyValueNode)resourceNode, resourceTypeReference, resourceNode);
        }
        this.mergedResources.add(resourceNode);
        return node;
    }

    private void checkTraits(KeyValueNode resourceNode, ResourceNode baseResourceNode) {
        List<MethodNode> methodNodes = this.findMethodNodes(resourceNode);
        List<ReferenceNode> resourceTraitRefs = this.findTraitReferences(resourceNode);
        List<ReferenceNode> presentResourceTraitRefs = this.validateAndFilterResourceLevelTraitRefs(resourceTraitRefs);
        for (MethodNode methodNode : methodNodes) {
            List<ReferenceNode> traitRefs = this.findTraitReferences((KeyValueNode)methodNode);
            traitRefs.addAll(presentResourceTraitRefs);
            for (ReferenceNode traitRef : traitRefs) {
                String traitLevel = presentResourceTraitRefs.contains(traitRef) ? "resource" : "method";
                this.logger.debug("applying {} level trait '{}' to '{}.{}'", new Object[]{traitLevel, traitRef.getRefName(), resourceNode.getKey(), methodNode.getName()});
                this.applyTrait(methodNode, traitRef, baseResourceNode);
            }
        }
    }

    private List<ReferenceNode> validateAndFilterResourceLevelTraitRefs(List<ReferenceNode> resourceTraitRefs) {
        ArrayList<ReferenceNode> presentTraitRefs = new ArrayList<ReferenceNode>();
        for (ReferenceNode traitReference : resourceTraitRefs) {
            Node refNode = traitReference.getRefNode();
            if (refNode == null) {
                ErrorNode errorNode = ErrorNodeFactory.createNonexistentReferenceTraitError((ReferenceNode)traitReference);
                traitReference.replaceWith((Node)errorNode);
                continue;
            }
            presentTraitRefs.add(traitReference);
        }
        return presentTraitRefs;
    }

    private void applyResourceType(KeyValueNode targetNode, ReferenceNode resourceTypeReference, ResourceNode baseResourceNode) {
        ResourceTypeNode refNode = (ResourceTypeNode)resourceTypeReference.getRefNode();
        if (refNode == null) {
            ErrorNode errorNode = ErrorNodeFactory.createNonexistentReferenceResourceTypeError((ReferenceNode)resourceTypeReference);
            resourceTypeReference.replaceWith((Node)errorNode);
            return;
        }
        ResourceTypeNode templateNode = refNode.copy();
        templateNode.setParent(refNode.getParent());
        Map<String, String> parameters = this.getBuiltinResourceTypeParameters(baseResourceNode);
        if (resourceTypeReference instanceof ParametrizedReferenceNode) {
            parameters.putAll(((ParametrizedReferenceNode)resourceTypeReference).getParameters());
        }
        this.resolveParameters((Node)templateNode, parameters);
        GrammarPhase grammarPhase = new GrammarPhase(this.ramlGrammar.resourceTypeParamsResolved());
        TransformationPhase referenceResolution = new TransformationPhase(new Transformer[]{new ReferenceResolverTransformer()});
        boolean success = this.applyPhases((KeyValueNode)templateNode, new Phase[]{grammarPhase, referenceResolution});
        if (success) {
            this.checkTraits((KeyValueNode)templateNode, baseResourceNode);
            ReferenceNode parentTypeReference = this.findResourceTypeReference((KeyValueNode)templateNode);
            if (parentTypeReference != null) {
                this.applyResourceType((KeyValueNode)templateNode, parentTypeReference, baseResourceNode);
            }
        }
        ResourceTypesTraitsMerger.merge(targetNode.getValue(), templateNode.getValue());
    }

    private boolean applyPhases(KeyValueNode templateNode, Phase ... phases) {
        List errorNodes = templateNode.findDescendantsWith(ErrorNode.class);
        if (errorNodes.isEmpty()) {
            for (Phase phase : phases) {
                phase.apply(templateNode.getValue());
                errorNodes = templateNode.findDescendantsWith(ErrorNode.class);
                if (errorNodes.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private Map<String, String> getBuiltinResourceTypeParameters(ResourceNode resourceNode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resourcePathName", resourceNode.getResourcePathName());
        parameters.put("resourcePath", resourceNode.getResourcePath());
        return parameters;
    }

    private Map<String, String> getBuiltinTraitParameters(MethodNode methodNode, ResourceNode resourceNode) {
        Map<String, String> parameters = this.getBuiltinResourceTypeParameters(resourceNode);
        parameters.put("methodName", methodNode.getName());
        return parameters;
    }

    private void applyTrait(MethodNode methodNode, ReferenceNode traitReference, ResourceNode baseResourceNode) {
        TraitNode refNode = (TraitNode)traitReference.getRefNode();
        if (refNode == null) {
            ErrorNode errorNode = ErrorNodeFactory.createNonexistentReferenceTraitError((ReferenceNode)traitReference);
            traitReference.replaceWith((Node)errorNode);
            return;
        }
        TraitNode copy = refNode.copy();
        copy.setParent(refNode.getParent());
        Map<String, String> parameters = this.getBuiltinTraitParameters(methodNode, baseResourceNode);
        if (traitReference instanceof ParametrizedReferenceNode) {
            parameters.putAll(((ParametrizedReferenceNode)traitReference).getParameters());
        }
        this.resolveParameters((Node)copy, parameters);
        GrammarPhase validatePhase = new GrammarPhase(this.ramlGrammar.traitParamsResolved());
        TransformationPhase referenceResolution = new TransformationPhase(new Transformer[]{new ReferenceResolverTransformer()});
        this.applyPhases((KeyValueNode)copy, new Phase[]{validatePhase, referenceResolution});
        this.replaceNullValueWithObject((KeyValueNode)methodNode);
        ResourceTypesTraitsMerger.merge(methodNode.getValue(), copy.getValue());
    }

    private void resolveParameters(Node parameterizedNode, Map<String, String> parameters) {
        ExecutionContext context = new ExecutionContext(parameters);
        List templateNodes = parameterizedNode.findDescendantsWith(StringTemplateNode.class);
        for (StringTemplateNode templateNode : templateNodes) {
            Node resolvedNode = templateNode.execute(context);
            templateNode.replaceWith(resolvedNode);
            resolvedNode.removeChildren();
        }
    }

    private void replaceNullValueWithObject(KeyValueNode keyValueNode) {
        Node valueNode = keyValueNode.getValue();
        if (valueNode instanceof SYNullNode) {
            SYBaseRamlNode ramlNode = (SYBaseRamlNode)valueNode;
            valueNode = new SYObjectNode(ramlNode);
            keyValueNode.setValue(valueNode);
        }
    }

    private List<ReferenceNode> findTraitReferences(KeyValueNode keyValueNode) {
        ArrayList<ReferenceNode> result = new ArrayList<ReferenceNode>();
        Node isNode = NodeSelector.selectFrom((String)"is", (Node)keyValueNode.getValue());
        if (isNode != null) {
            List children = isNode.getChildren();
            for (Node child : children) {
                result.add((ReferenceNode)child);
            }
        }
        return result;
    }

    private ReferenceNode findResourceTypeReference(KeyValueNode resourceNode) {
        return (ReferenceNode)NodeSelector.selectFrom((String)"type", (Node)resourceNode.getValue());
    }

    private List<MethodNode> findMethodNodes(KeyValueNode resourceNode) {
        ArrayList<MethodNode> methodNodes = new ArrayList<MethodNode>();
        for (Node node : resourceNode.getValue().getChildren()) {
            if (!(node instanceof MethodNode)) continue;
            methodNodes.add((MethodNode)node);
        }
        return methodNodes;
    }
}

