/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import org.raml.v2.internal.impl.commons.nodes.AnnotationNode;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.ExtendsNode;
import org.raml.v2.internal.impl.commons.nodes.OverlayableNode;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsMerger {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionsMerger.class);
    private boolean overlay;

    public ExtensionsMerger(boolean overlay) {
        this.overlay = overlay;
    }

    public void merge(Node baseNode, Node copyNode) {
        if (baseNode instanceof ObjectNode && copyNode instanceof ObjectNode) {
            this.merge((ObjectNode)baseNode, (ObjectNode)copyNode);
        } else if (baseNode instanceof ArrayNode && copyNode instanceof ArrayNode) {
            this.merge((ArrayNode)baseNode, (ArrayNode)copyNode);
        } else {
            throw new RuntimeException(String.format("Merging not supported for nodes of type %s and %s", baseNode.getClass().getSimpleName(), copyNode.getClass().getSimpleName()));
        }
    }

    private void merge(ArrayNode baseNode, ArrayNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            baseNode.addChild(child);
        }
    }

    private void merge(ObjectNode baseNode, ObjectNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            if (!(child instanceof KeyValueNode)) {
                throw new RuntimeException("only expecting KeyValueNode");
            }
            Node keyNode = ((KeyValueNode)child).getKey();
            String key = keyNode.toString();
            if (this.shouldIgnoreNode(child)) {
                logger.debug("Ignoring key '{}'", (Object)key);
                continue;
            }
            Node valueNode = ((KeyValueNode)child).getValue();
            Node node = NodeSelector.selectFrom((String)NodeSelector.encodePath((String)key), (Node)baseNode);
            if (node == null) {
                this.overlayCheck(valueNode, valueNode);
                logger.debug("Adding key '{}'", (Object)key);
                baseNode.addChild(child);
                continue;
            }
            if (child instanceof AnnotationNode) {
                logger.debug("Replacing annotation '{}'", (Object)key);
                ((KeyValueNode)node.getParent()).setValue(valueNode);
                continue;
            }
            if (child instanceof ExampleDeclarationNode) {
                logger.debug("Replacing example '{}'", (Object)key);
                ((KeyValueNode)node.getParent()).setValue(valueNode);
                continue;
            }
            if (this.isDefaultNode(child)) {
                logger.debug("Ignoring default key '{}'", (Object)key);
                continue;
            }
            if (valueNode instanceof SimpleTypeNode) {
                if (!this.overlayCheck(node, valueNode)) continue;
                logger.debug("Replacing existing scalar key '{}'", (Object)key);
                node.replaceWith(valueNode);
                continue;
            }
            logger.debug("Merging values '{}' and '{}'", (Object)node.getParent(), (Object)child);
            this.merge(node, valueNode);
        }
    }

    private boolean isDefaultNode(Node node) {
        return node.getStartPosition().getLine() == -1 && node.getEndPosition().getLine() == -1;
    }

    private boolean overlayCheck(Node baseNode, Node overlayNode) {
        boolean check = true;
        if (this.overlay && !(overlayNode instanceof OverlayableNode) && !(overlayNode.getParent() instanceof OverlayableNode)) {
            baseNode.replaceWith((Node)ErrorNodeFactory.createInvalidOverlayNode((Node)overlayNode));
            check = false;
        }
        return check;
    }

    private boolean shouldIgnoreNode(Node node) {
        if (node instanceof ExtendsNode) {
            return true;
        }
        return this.isUsageNode(node);
    }

    private boolean isUsageNode(Node node) {
        Node keyNode = ((KeyValueNode)node).getKey();
        String key = keyNode.toString();
        return "usage".equals(key) && node.getParent() instanceof RamlDocumentNode;
    }
}

