/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.OverlayableNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeUtils;

public class TypeDeclarationNode
extends AbstractRamlNode
implements ObjectNode,
OverlayableNode {
    private ResolvedType resolvedType;

    public TypeDeclarationNode() {
    }

    protected TypeDeclarationNode(TypeDeclarationNode node) {
        super((AbstractRamlNode)node);
    }

    @Nonnull
    public List<TypeExpressionNode> getBaseTypes() {
        ArrayList<TypeExpressionNode> result = new ArrayList<TypeExpressionNode>();
        Node type = this.getTypeValue();
        if (type instanceof ArrayNode) {
            List children = type.getChildren();
            for (Node child : children) {
                result.add((TypeExpressionNode)child);
            }
        } else {
            result.add((TypeExpressionNode)type);
        }
        return result;
    }

    public ResolvedType getResolvedType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.resolveTypeDefinition();
        }
        return this.resolvedType;
    }

    protected ResolvedType resolveTypeDefinition() {
        List<TypeExpressionNode> baseTypes = this.getBaseTypes();
        ResolvedType result = null;
        for (TypeExpressionNode baseType : baseTypes) {
            ResolvedType baseTypeDef = baseType.generateDefinition(this);
            if (result == null) {
                result = baseTypeDef;
                continue;
            }
            if (baseTypeDef instanceof UnionResolvedType && !(result instanceof UnionResolvedType)) {
                result = baseTypeDef.mergeFacets(result);
                continue;
            }
            result = result.mergeFacets(baseTypeDef);
        }
        if (result != null) {
            result = result.overwriteFacets(this);
        }
        return result;
    }

    private Node getTypeValue() {
        return NodeUtils.getType((Node)this);
    }

    @Nullable
    public String getTypeName() {
        if (this.getParent() instanceof TypeDeclarationField) {
            return ((SimpleTypeNode)((TypeDeclarationField)this.getParent()).getKey()).getLiteralValue();
        }
        return null;
    }

    @Nonnull
    public Node copy() {
        return new TypeDeclarationNode(this);
    }

    public NodeType getType() {
        return NodeType.Object;
    }
}

