/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model.type;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.ws.commons.schema.XmlSchema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.model.Annotable;
import org.raml.v2.internal.impl.commons.model.RamlValidationResult;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.SchemaBasedResolvedType;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.phase.ExampleValidationPhase;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeToSchemaVisitor;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.util.NodeSelector;

public abstract class TypeDeclaration<T extends ResolvedType>
extends Annotable {
    private KeyValueNode node;
    private T resolvedType;

    public TypeDeclaration(KeyValueNode node, T resolvedType) {
        this.node = node;
        this.resolvedType = resolvedType;
    }

    public T getResolvedType() {
        return this.resolvedType;
    }

    public Node getNode() {
        return this.node.getValue();
    }

    public String name() {
        if (this.node instanceof PropertyNode) {
            return ((PropertyNode)this.node).getName();
        }
        return ((StringNode)this.node.getKey()).getValue();
    }

    public String schemaContent() {
        ResolvedType resolvedType;
        TypeDeclarationNode value;
        List<TypeExpressionNode> baseTypes;
        if (this.node.getValue() instanceof TypeDeclarationNode && !(baseTypes = (value = (TypeDeclarationNode)this.node.getValue()).getBaseTypes()).isEmpty() && (resolvedType = baseTypes.get(0).generateDefinition(value)) instanceof SchemaBasedResolvedType) {
            return ((SchemaBasedResolvedType)resolvedType).getSchemaValue();
        }
        return null;
    }

    public List<RamlValidationResult> validate(String payload) {
        TypeDeclarationNode node = (TypeDeclarationNode)this.getNode();
        ResourceLoader resourceLoader = node.getStartPosition().getResourceLoader();
        ExampleValidationPhase exampleValidationPhase = new ExampleValidationPhase(resourceLoader);
        Node validate = exampleValidationPhase.validate(node, (Node)new StringNodeImpl(payload));
        if (validate instanceof ErrorNode) {
            return Collections.singletonList(new RamlValidationResult((ErrorNode)validate));
        }
        return Collections.emptyList();
    }

    public Boolean required() {
        if (this.node instanceof PropertyNode) {
            return ((PropertyNode)this.node).isRequired();
        }
        return (Boolean)NodeSelector.selectType((String)"required", (Node)this.getNode(), (Object)true);
    }

    public String defaultValue() {
        Object defaultValue = NodeSelector.selectType((String)"default", (Node)this.getNode(), null);
        return defaultValue != null ? defaultValue.toString() : null;
    }

    public String toXmlSchema() {
        if (this.getResolvedType() instanceof SchemaBasedResolvedType || this.getResolvedType() instanceof AnyResolvedType || this.getResolvedType() == null) {
            return null;
        }
        TypeToSchemaVisitor typeToSchemaVisitor = new TypeToSchemaVisitor();
        typeToSchemaVisitor.transform(this.name(), (ResolvedType)this.getResolvedType());
        XmlSchema schema = typeToSchemaVisitor.getSchema();
        StringWriter writer = new StringWriter();
        schema.write((Writer)writer);
        return writer.toString();
    }
}

