/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.KeyValueNodeImpl;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.ObjectNode;
import org.raml.v2.internal.framework.nodes.SchemaNodeImpl;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYNullNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYObjectNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYStringNode;
import org.raml.v2.internal.framework.phase.Transformer;
import org.raml.v2.internal.impl.commons.model.BuiltInScalarType;
import org.raml.v2.internal.impl.commons.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.nodes.types.InheritedPropertiesInjectedNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.ObjectTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.UnionTypeNode;
import org.raml.v2.internal.utils.NodeUtils;
import org.raml.v2.internal.utils.SchemaGenerator;

public class TypesTransformer
implements Transformer {
    private String actualPath;

    public TypesTransformer(String actualPath) {
        this.actualPath = actualPath;
    }

    public TypesTransformer() {
    }

    @Override
    public boolean matches(Node node) {
        return node instanceof ObjectTypeNode;
    }

    @Override
    public Node transform(Node node) {
        if (node instanceof UnionTypeNode) {
            this.transformUnionTypeProperties(node);
        } else if (node instanceof ObjectTypeNode && NodeUtils.getType(node) instanceof SYArrayNode) {
            this.transformObjectTypeProperties(node);
        }
        this.validateGeneratedProperties(node);
        return node;
    }

    private void validateGeneratedProperties(Node node) {
        if (node instanceof ObjectTypeNode) {
            ObjectTypeNode objectNode = (ObjectTypeNode)node;
            Integer totalNumberOfProperties = this.getNumberOfProperties(node);
            if (objectNode.getMinProperties() != null && objectNode.getMinProperties().compareTo(totalNumberOfProperties) > 0) {
                node.replaceWith(ErrorNodeFactory.createInvalidNumberOfProperties("minimum", objectNode.getMinProperties(), totalNumberOfProperties));
            }
            if (objectNode.getMaxProperties() != null && objectNode.getMaxProperties().compareTo(totalNumberOfProperties) < 0) {
                node.replaceWith(ErrorNodeFactory.createInvalidNumberOfProperties("maximum", objectNode.getMaxProperties(), totalNumberOfProperties));
            }
        }
    }

    private Integer getNumberOfProperties(Node node) {
        Node properties = node.get("properties");
        if (properties == null) {
            return 0;
        }
        return properties.getChildren().size();
    }

    private void transformObjectTypeProperties(Node node) {
        Node properties = node.get("properties");
        SYArrayNode typesNode = (SYArrayNode)NodeUtils.getType(node);
        if (typesNode != null) {
            Set<List<String>> typeCombinations = this.validateAndGetPossibleTypes(typesNode);
            for (List<String> combination : typeCombinations) {
                Node originalProperties = properties != null ? properties.copy() : null;
                for (String objectTypeName : combination) {
                    originalProperties = this.processType(originalProperties, node, objectTypeName);
                }
                this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(combination.toString()), (SYObjectNode)originalProperties);
            }
        }
    }

    private Node processType(Node originalProperties, Node context, String objectType) {
        TypeNode typeNode = NodeUtils.getType(objectType, context);
        if (typeNode instanceof ObjectTypeNode) {
            if (!((ObjectTypeNode)typeNode).isResolved()) {
                this.transform(typeNode);
            }
            if (originalProperties == null) {
                SYObjectNode newProperties = (SYObjectNode)typeNode.get("properties");
                if (newProperties != null) {
                    originalProperties = newProperties.copy();
                }
            } else {
                List<PropertyNode> unionProperties = !((ObjectTypeNode)typeNode).getInheritedProperties().isEmpty() ? ((ObjectTypeNode)typeNode).getInheritedProperties().get(0).findDescendantsWith(PropertyNode.class) : this.getTypeProperties((ObjectTypeNode)typeNode);
                this.addProperties(originalProperties, unionProperties);
            }
        }
        return originalProperties;
    }

    private void transformUnionTypeProperties(Node node) {
        block14: {
            StringNode typeNode;
            block13: {
                typeNode = (StringNode)NodeUtils.getType(node);
                if (SchemaGenerator.isSchemaNode(node)) {
                    SchemaGenerator.wrapNode(node, this.actualPath);
                    return;
                }
                this.validateInheritedTypes(typeNode);
                Node properties = node.get("properties");
                if (properties == null) break block13;
                if (typeNode == null) break block14;
                for (String type : this.getSplitTypes(typeNode.getValue())) {
                    String trimmedType = StringUtils.trim((String)type);
                    Node unionProperties = this.processType(properties.copy(), node, trimmedType);
                    if (unionProperties != null && !(unionProperties instanceof SYNullNode)) {
                        this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(trimmedType), (SYObjectNode)unionProperties);
                    }
                    ((ObjectTypeNode)node).markAsResolved();
                }
                break block14;
            }
            if (NodeUtils.getType(node) instanceof StringNode) {
                String trimmedType = StringUtils.trim((String)((StringNode)NodeUtils.getType(node)).getValue());
                if ("array".equals(trimmedType)) {
                    if (NodeUtils.getType(node.get("items")) == null) {
                        return;
                    }
                    trimmedType = StringUtils.trim((String)((StringNode)NodeUtils.getType(node.get("items"))).getValue());
                    if (StringUtils.isEmpty((String)trimmedType)) {
                        return;
                    }
                }
                if (SchemaGenerator.isSchemaNode(NodeUtils.getType(node))) {
                    SchemaGenerator.wrapNode(NodeUtils.getType(node), this.actualPath);
                    return;
                }
                for (String type : this.getSplitTypes(trimmedType)) {
                    TypeNode parentTypeNodeGeneral = NodeUtils.getType(type, typeNode);
                    if (!(parentTypeNodeGeneral instanceof ObjectTypeNode)) continue;
                    ObjectTypeNode parentTypeNode = (ObjectTypeNode)parentTypeNodeGeneral;
                    if (!parentTypeNode.isResolved()) {
                        this.transform(parentTypeNode);
                    }
                    if (!parentTypeNode.getInheritedProperties().isEmpty()) {
                        for (InheritedPropertiesInjectedNode inheritedProperties : parentTypeNode.getInheritedProperties()) {
                            this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(type), inheritedProperties);
                            ((ObjectTypeNode)node).markAsResolved();
                        }
                        continue;
                    }
                    if (parentTypeNode.get("properties") != null) {
                        this.injectProperties((ObjectTypeNode)node, new StringNodeImpl(type), (SYObjectNode)parentTypeNode.get("properties"));
                        ((ObjectTypeNode)node).markAsResolved();
                        continue;
                    }
                    if (!SchemaGenerator.isSchemaNode(NodeUtils.getType(parentTypeNode))) continue;
                    SchemaNodeImpl schemaNode = new SchemaNodeImpl((StringNodeImpl)NodeUtils.getType(parentTypeNode), this.actualPath);
                    NodeUtils.getType(node).replaceWith(schemaNode);
                    return;
                }
            }
        }
    }

    private String[] getSplitTypes(String types) {
        String[] split = StringUtils.replaceEach((String)types, (String[])new String[]{"(", ")"}, (String[])new String[]{"", ""}).split("\\|");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringUtils.trim((String)split[i]);
        }
        return split;
    }

    private void validateInheritedTypes(StringNode typeNode) {
        if (typeNode != null && this.isCustomRamlType(typeNode) && !SchemaGenerator.isSchemaNode(typeNode)) {
            for (String type : this.getSplitTypes(typeNode.getValue())) {
                String trimmedType = StringUtils.trim((String)type);
                TypeNode parentTypeNode = NodeUtils.getType(trimmedType, typeNode);
                if (((ObjectTypeNode)NodeUtils.getAncestor(typeNode, 2)).isResolved() || parentTypeNode != null) continue;
                ErrorNode errorNode = ErrorNodeFactory.createInexistentType(trimmedType);
                typeNode.replaceWith(errorNode);
            }
        }
    }

    private boolean isCustomRamlType(StringNode typeNode) {
        String typeNodeValue = typeNode.getValue();
        return !BuiltInScalarType.isBuiltInScalarType(typeNodeValue) && !typeNodeValue.equals("array") && !typeNodeValue.equals("object") && !SchemaGenerator.isSchemaNode(typeNode);
    }

    private void addProperties(Node properties, List<PropertyNode> unionProperties) {
        if (unionProperties != null) {
            for (PropertyNode property : unionProperties) {
                Node existingProperty = properties.get(property.getName());
                if (existingProperty != null) {
                    ErrorNode errorNode = new ErrorNode("property definition {" + existingProperty.getParent() + "} overrides existing property: {" + property + "}");
                    errorNode.setSource(existingProperty);
                    properties.addChild(errorNode);
                    continue;
                }
                properties.addChild(property);
            }
        }
    }

    private Set<List<String>> validateAndGetPossibleTypes(SYArrayNode typesNode) {
        ArrayList types = Lists.newArrayList();
        for (Node typeNode : typesNode.getChildren()) {
            String typeElement = ((SYStringNode)typeNode).getValue();
            LinkedHashSet splitTypes = Sets.newLinkedHashSet();
            for (String type : this.getSplitTypes(typeElement)) {
                if (!StringUtils.isNotBlank((String)StringUtils.trimToNull((String)type))) continue;
                String objectType = StringUtils.trim((String)type);
                TypeNode typeDefinition = NodeUtils.getType(objectType, typeNode);
                if (typeDefinition == null) {
                    ErrorNode error = ErrorNodeFactory.createInexistentType(objectType);
                    typeNode.replaceWith(error);
                    continue;
                }
                splitTypes.add(objectType);
            }
            types.add(splitTypes);
        }
        return Sets.cartesianProduct((List)types);
    }

    private List<PropertyNode> getTypeProperties(ObjectTypeNode node) {
        return node.getProperties();
    }

    private void injectProperties(ObjectTypeNode node, StringNodeImpl key, ObjectNode properties) {
        InheritedPropertiesInjectedNode injected = new InheritedPropertiesInjectedNode();
        KeyValueNodeImpl keyValue = new KeyValueNodeImpl(key, properties);
        this.setKeyPosition(key, properties, injected, keyValue);
        injected.setParent(node);
        node.addInheritedProperties(injected);
    }

    private void setKeyPosition(StringNodeImpl key, ObjectNode properties, Node injected, KeyValueNode keyValue) {
        key.setEndPosition(properties.getStartPosition());
        key.setStartPosition(properties.getStartPosition().leftShift(key.getValue().length()));
        injected.addChild(keyValue);
    }
}

