/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.nodes.types.factories;

import org.raml.v2.internal.framework.grammar.rule.NodeFactory;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.BooleanTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.DateTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.FileTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.FloatTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.IntegerTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.ObjectTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.StringTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.UnionTypeNode;
import org.raml.v2.internal.utils.NodeUtils;

public class TypeNodeFactory
implements NodeFactory {
    @Override
    public Node create(Object ... args) {
        StringNode type;
        Node typeNode = NodeUtils.getType((Node)args[0]);
        if (typeNode instanceof SYArrayNode) {
            return new ObjectTypeNode();
        }
        StringNode stringNode = type = typeNode instanceof StringNode ? (StringNode)typeNode : null;
        if (type == null) {
            return new StringTypeNode();
        }
        String value = type.getValue();
        return TypeNodeFactory.createNodeFromType(value);
    }

    public static Node createNodeFromType(String value) {
        switch (value) {
            case "string": {
                return new StringTypeNode();
            }
            case "number": {
                return new FloatTypeNode();
            }
            case "integer": {
                return new IntegerTypeNode();
            }
            case "boolean": {
                return new BooleanTypeNode();
            }
            case "file": {
                return new FileTypeNode();
            }
            case "object": {
                return new ObjectTypeNode();
            }
            case "date-only": 
            case "time-only": 
            case "datetime-only": 
            case "datetime": {
                return new DateTypeNode();
            }
        }
        return new UnionTypeNode();
    }
}

