/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.List;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.KeyValueNodeImpl;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NullNode;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYNullNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYStringNode;
import org.raml.v2.internal.framework.phase.Phase;
import org.raml.v2.internal.impl.commons.model.BuiltInScalarType;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.BooleanTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.FloatTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.IntegerTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.ObjectTypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.StringTypeNode;
import org.raml.v2.internal.utils.NodeUtils;

public class SugarRushPhase
implements Phase {
    @Override
    public Node apply(Node tree) {
        this.sweetenBuiltInTypes(tree);
        this.sweetenObjects(tree);
        this.sweetenAnnotations(tree);
        return tree;
    }

    private void sweetenBuiltInTypes(Node tree) {
        List<StringNode> basicSugar = tree.findDescendantsWith(StringNode.class);
        for (StringNode sugarNode : basicSugar) {
            if (BuiltInScalarType.isBuiltInScalarType(sugarNode.getValue()) && !this.isTypePresentBasic(sugarNode)) {
                this.handleBuiltInType(sugarNode);
                continue;
            }
            if ("array".equals(sugarNode.getValue())) {
                this.handleArray(sugarNode);
                continue;
            }
            if (this.isArraySugar(sugarNode)) {
                this.handleObjectArray(sugarNode);
                continue;
            }
            if (!this.isStringSugar(sugarNode)) continue;
            this.setTypeString(sugarNode.getParent());
        }
    }

    private boolean isStringSugar(StringNode sugarNode) {
        Node ancestor = NodeUtils.getAncestor(sugarNode, 3);
        Node parent = sugarNode.getParent();
        return parent instanceof KeyValueNode && ((KeyValueNode)parent).getValue() instanceof NullNode && ancestor instanceof KeyValueNode && ((KeyValueNode)ancestor).getKey() instanceof StringNode && ("types".equals(((StringNode)((KeyValueNode)ancestor).getKey()).getValue()) || "schemas".equals(((StringNode)((KeyValueNode)ancestor).getKey()).getValue()) || "properties".equals(((StringNode)((KeyValueNode)ancestor).getKey()).getValue()));
    }

    private void sweetenObjects(Node tree) {
        List<StringNode> basicSugar = tree.findDescendantsWith(StringNode.class);
        for (StringNode sugarNode : basicSugar) {
            if (!"properties".equals(sugarNode.getValue()) || this.isTypePresentObject(sugarNode)) continue;
            Node grandParent = sugarNode.getParent().getParent();
            grandParent.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl("object")));
        }
    }

    private void sweetenAnnotations(Node tree) {
        Node annotationsNode = tree.get("annotationTypes");
        if (annotationsNode != null) {
            for (Node annotation : annotationsNode.getChildren()) {
                if (!this.isTypeMissingInAnnotation(annotation) || !this.isStringAnnotation(annotation)) continue;
                this.setTypeString(annotation);
            }
        }
    }

    private void handleObjectArray(StringNode sugarNode) {
        String keyString;
        Node parent = sugarNode.getParent();
        Node key = this.isKeyValueNode(parent) ? ((KeyValueNode)parent).getKey() : null;
        String string = keyString = key instanceof StringNode ? ((StringNode)key).getValue() : null;
        if (parent instanceof KeyValueNode && "type".equals(keyString)) {
            Node grandParent = parent.getParent();
            grandParent.removeChild(parent);
            KeyValueNodeImpl items = this.handleArraySugar(sugarNode, grandParent);
            items.setSource(parent);
            grandParent.addChild(items);
        } else {
            ObjectTypeNode newNode = new ObjectTypeNode();
            KeyValueNodeImpl items = this.handleArraySugar(sugarNode, newNode);
            items.setSource(parent);
            newNode.addChild(items);
            sugarNode.replaceWith(newNode);
        }
    }

    private boolean isArraySugar(StringNode sugarNode) {
        return sugarNode.getValue() != null && sugarNode.getValue().endsWith("[]");
    }

    private void handleArray(StringNode sugarNode) {
        Node itemsNode;
        if (sugarNode.getParent() != null && sugarNode.getParent().getParent() != null && (itemsNode = sugarNode.getParent().getParent().get("items")) instanceof SYNullNode) {
            itemsNode.replaceWith(new StringNodeImpl(new StringNodeImpl("string")));
        }
    }

    private KeyValueNodeImpl handleArraySugar(StringNode sugarNode, Node grandParent) {
        String value = sugarNode.getValue().split("\\[")[0];
        grandParent.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl("array")));
        return new KeyValueNodeImpl(new StringNodeImpl("items"), new StringNodeImpl(value));
    }

    private void handleBuiltInType(StringNode sugarNode) {
        Node newNode;
        if (sugarNode.getChildren().isEmpty() && (newNode = this.getSugarNode(sugarNode.getValue())) != null) {
            newNode.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl(sugarNode.getValue())));
            sugarNode.replaceWith(newNode);
        }
    }

    private void setTypeString(Node annotation) {
        if (this.isKeyValueNode(annotation)) {
            StringTypeNode stringTypeNode = new StringTypeNode();
            stringTypeNode.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl("string")));
            ((KeyValueNode)annotation).getValue().replaceWith(stringTypeNode);
        }
    }

    private boolean isStringAnnotation(Node annotation) {
        return this.isKeyValueNode(annotation) && ((KeyValueNode)annotation).getValue().get("properties") == null;
    }

    private boolean isKeyValueNode(Node annotation) {
        return annotation instanceof KeyValueNode;
    }

    private boolean isTypeMissingInAnnotation(Node annotation) {
        return this.isKeyValueNode(annotation) && NodeUtils.getType(((KeyValueNode)annotation).getValue()) == null;
    }

    private boolean isTypePresentBasic(Node sugarNode) {
        Node parent = sugarNode.getParent();
        if (this.isKeyValueNode(parent) && ((KeyValueNode)parent).getKey() instanceof SYStringNode) {
            SYStringNode key = (SYStringNode)((KeyValueNode)parent).getKey();
            return "type".equals(key.getValue());
        }
        return false;
    }

    private boolean isTypePresentObject(Node sugarNode) {
        return NodeUtils.getType(sugarNode.getParent().getParent()) != null;
    }

    private Node getSugarNode(String typeNode) {
        if (BuiltInScalarType.STRING.getType().equals(typeNode)) {
            return new StringTypeNode();
        }
        if (BuiltInScalarType.NUMBER.getType().equals(typeNode)) {
            return new FloatTypeNode();
        }
        if (BuiltInScalarType.INTEGER.getType().equals(typeNode)) {
            return new IntegerTypeNode();
        }
        if (BuiltInScalarType.BOOLEAN.getType().equals(typeNode)) {
            return new BooleanTypeNode();
        }
        if ("object".equals(typeNode)) {
            return new ObjectTypeNode();
        }
        return null;
    }
}

