/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.nodes.ExecutableNode;
import org.raml.v2.internal.framework.nodes.ExecutionContext;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNodeImpl;
import org.raml.v2.internal.utils.Inflector;

public class TemplateExpressionNode
extends StringNodeImpl
implements ExecutableNode {
    public TemplateExpressionNode(@Nonnull String value) {
        super(value);
    }

    public TemplateExpressionNode(TemplateExpressionNode node) {
        super(node);
    }

    @Nullable
    public String getVariableName() {
        StringTokenizer expressionTokens = this.getExpressionTokens();
        return expressionTokens.hasMoreTokens() ? expressionTokens.nextToken() : null;
    }

    @Override
    public Node execute(ExecutionContext context) {
        String token;
        StringTokenizer expressionTokens = this.getExpressionTokens();
        String result = null;
        if (expressionTokens.hasMoreTokens()) {
            token = expressionTokens.nextToken().trim();
            if (context.containsVariable(token)) {
                result = context.getVariable(token);
            } else {
                return ErrorNodeFactory.createInvalidTemplateParameterExpression(this, token);
            }
        }
        while (expressionTokens.hasMoreTokens()) {
            token = expressionTokens.nextToken().trim();
            if (token.startsWith("!")) {
                try {
                    Method method = Inflector.class.getMethod(token.substring(1), String.class);
                    result = String.valueOf(method.invoke(null, result));
                    continue;
                }
                catch (Exception e) {
                    return ErrorNodeFactory.createInvalidTemplateFunctionExpression(this, token);
                }
            }
            return ErrorNodeFactory.createInvalidTemplateFunctionExpression(this, token);
        }
        return new StringNodeImpl(result);
    }

    private StringTokenizer getExpressionTokens() {
        String value = this.getValue();
        return new StringTokenizer(value, "|");
    }

    @Override
    @Nonnull
    public Node copy() {
        return new TemplateExpressionNode(this);
    }
}

